package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceClockVoRepository;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceClockVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceClockVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 考勤打卡明细(AttendanceClockVo)表服务实现类
 * @Author dy
 * @DATE 2022/3/14
 **/
@Service("AttendanceClockVoServiceImpl")
public class AttendanceClockVoServiceImpl implements AttendanceClockVoService {

  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private AttendanceClockVoRepository attendanceClockVoRepository;

  /**
   * 分页查询数据
   *
   * @param pageable        分页对象
   * @param attendanceClockConditionDto 实体对象
   * @return
   */
  @Override
  public Page<AttendanceClockVo> findByConditions(Pageable pageable, AttendanceClockConditionDto attendanceClockConditionDto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(attendanceClockConditionDto)) {
      attendanceClockConditionDto = new AttendanceClockConditionDto();
    }
    LoginUserDetailsForCPS loginDetails = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginDetails,"获取当前登录用户信息失败");
    attendanceClockConditionDto.setUserAccount(loginDetails.getConsumerCode());
    Page<AttendanceClockVo> page = attendanceClockVoRepository.findByConditions(pageable, attendanceClockConditionDto);
    return page;
  }
}
