package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceDetailReportVoMapper;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceDetailReportVoRepository;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailConditionDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailReportConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceDetailReportVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceDetailReportVo;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 考勤报表(AttendanceDetailReportVoService)服务实现类
 * @Author dy
 * @DATE 2022/3/3
 **/
@Service("AttendanceDetailReportVoServiceImpl")
public class AttendanceDetailReportVoServiceImpl implements AttendanceDetailReportVoService {

  @Autowired
  private AttendanceDetailReportVoRepository attendanceDetailReportVoRepository;

  @Override
  public Page<AttendanceDetailReportVo> findByConditions(Pageable pageable, AttendanceDetailReportConditionDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new AttendanceDetailReportConditionDto();
    }
    return attendanceDetailReportVoRepository.findByConditions(pageable,dto);
  }
}
