package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftApplicationVoRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftApplicationService;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceShiftApplicationVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftPlanVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.Objects;

/**
 * 排班申请Vo Service接口实现类
 *
 * @Author dy
 * @DATE 2022/2/18
 **/
@Service("attendanceShiftApplicationVoService")
public class AttendanceShiftApplicationVoServiceImpl implements AttendanceShiftApplicationVoService {

  @Autowired
  private AttendanceShiftApplicationVoRepository attendanceShiftApplicationVoRepository;
  @Autowired
  private AttendanceShiftApplicationService attendanceShiftApplicationService;
  @Autowired
  private LoginUserService loginUserService;

  @Override
  public Page<AttendanceShiftApplicationVo> findDetailsByConditions(Pageable pageable, ShiftApplicationConditionDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new ShiftApplicationConditionDto();
    }
    return this.attendanceShiftApplicationVoRepository.findDetailsByConditions(pageable, dto);
  }

  @Override
  public AttendanceShiftApplicationVo findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return attendanceShiftApplicationVoRepository.findDetailsById(id);
  }

  @Override
  public AttendanceShiftApplicationVo findDetailsByApplyCode(String applyCode) {
    if (StringUtils.isBlank(applyCode)) {
      return null;
    }
    return attendanceShiftApplicationVoRepository.findDetailsByApplyCode(applyCode);
  }

  @Override
  public AttendanceShiftApplicationVo findByCurrentUserAndApplyPeriodDate(Date applyPeriodDate) {
    if(Objects.isNull(applyPeriodDate)){
      return null;
    }
    LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    Validate.notNull(loginUser,"未能获取到当前登录的用户信息");
    String account = loginUser.getConsumerCode();
    String applyPeriod = this.attendanceShiftApplicationService.findApplyPeriodByDate(applyPeriodDate);
    return this.attendanceShiftApplicationVoRepository.findByUserAccountAndApplyPeriod(account,applyPeriod);
  }

  @Override
  public AttendanceShiftApplicationVo findByCurrentUserAndDate(Date date) {
    if(Objects.isNull(date)){
      return null;
    }
    AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.findByCurrentUserAndApplyPeriodDate(date);
    if(attendanceShiftApplicationVo == null){
      return null;
    }
    AttendanceShiftPlanVo attendanceShiftPlanVo = attendanceShiftApplicationVo.getShiftPlans().stream().filter(o -> DateUtils.isSameDay(date, o.getSchedulingDate())).findFirst().orElse(null);
    if(attendanceShiftPlanVo == null){
      return null;
    }
    attendanceShiftApplicationVo.setShiftPlans(Arrays.asList(attendanceShiftPlanVo));
    return attendanceShiftApplicationVo;
  }
}
