package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftOrganizationRelationship;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftOrganizationRelationshipRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftOrganizationRelationshipService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 班次与导购所属组织关联关系(ShiftOrganizationRelationship)表服务实现类
 *
 * @author makejava
 * @since 2022-02-16 15:37:44
 */
@Service("shiftOrganizationRelationshipService")
public class AttendanceShiftOrganizationRelationshipServiceImpl implements AttendanceShiftOrganizationRelationshipService {

  @Autowired
  private AttendanceShiftOrganizationRelationshipRepository attendanceShiftOrganizationRelationshipRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param attendanceShiftOrganizationRelationship 实体对象
   * @return
   */
  @Override
  public Page<AttendanceShiftOrganizationRelationship> findByConditions(Pageable pageable, AttendanceShiftOrganizationRelationship attendanceShiftOrganizationRelationship) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(attendanceShiftOrganizationRelationship)) {
      attendanceShiftOrganizationRelationship = new AttendanceShiftOrganizationRelationship();
    }
    return this.attendanceShiftOrganizationRelationshipRepository.findByConditions(pageable, attendanceShiftOrganizationRelationship);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public AttendanceShiftOrganizationRelationship findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.attendanceShiftOrganizationRelationshipRepository.getById(id);
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.attendanceShiftOrganizationRelationshipRepository.removeByIds(idList);
  }

  @Override
  @Transactional
  public void createBatch(String shiftCode, Set<AttendanceShiftOrganizationRelationship> shiftOrganizationRelationshipSet) {

    this.saveValidate(shiftOrganizationRelationshipSet);
    attendanceShiftOrganizationRelationshipRepository.saveBatch(shiftOrganizationRelationshipSet);
  }

  @Override
  public void deleteByShiftCode(String shiftCode) {
    if(StringUtils.isBlank(shiftCode)){
      return;
    }
    attendanceShiftOrganizationRelationshipRepository.deleteByShiftCode(shiftCode);
  }

  @Override
  public List<AttendanceShiftOrganizationRelationship> findByShiftCode(String shiftCode) {
    if(StringUtils.isBlank(shiftCode)){
      return Lists.newArrayList();
    }
    return attendanceShiftOrganizationRelationshipRepository.findByShiftCode(shiftCode);
  }

  /**
   * 保存前数据验证
   * @param shiftOrganizationRelationships
   */
  private void saveValidate(Set<AttendanceShiftOrganizationRelationship> shiftOrganizationRelationships){
    Validate.notNull(shiftOrganizationRelationships,"保存关联组织时，对象不能为空！");
    shiftOrganizationRelationships.forEach(this::createValidate);
  }

  /**
   * 创建验证
   * @param attendanceShiftOrganizationRelationship
   */
  private void createValidate(AttendanceShiftOrganizationRelationship attendanceShiftOrganizationRelationship) {
    Validate.notNull(attendanceShiftOrganizationRelationship, "新增时，对象信息不能为空！");
    attendanceShiftOrganizationRelationship.setId(null);
    Validate.notBlank(attendanceShiftOrganizationRelationship.getOrgCode(), "新增数据时， 所属组织编码 不能为空！");
    Validate.notBlank(attendanceShiftOrganizationRelationship.getOrgName(), "新增数据时， 所属组织名称 不能为空！");
    Validate.notBlank(attendanceShiftOrganizationRelationship.getShiftCode(), "新增数据时， 班次编码 不能为空！");
   
  }
}

