package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftUserRelationship;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftUserRelationshipRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftUserRelationshipService;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Set;

/**
 * 班次导购关联对象(AttendanceShiftUserRelationship)表服务实现类
 *
 * @author dy
 * @since 2022-02-16 15:37:45
 */
@Service("AttendanceShiftUserRelationshipService")
public class AttendanceShiftUserRelationshipServiceImpl implements AttendanceShiftUserRelationshipService {

  @Autowired
  private AttendanceShiftUserRelationshipRepository attendanceShiftUserRelationshipRepository;

  /**
   * 分页查询数据
   *
   * @param pageable                        分页对象
   * @param attendanceShiftUserRelationship 实体对象
   * @return
   */
  @Override
  public Page<AttendanceShiftUserRelationship> findByConditions(Pageable pageable, AttendanceShiftUserRelationship attendanceShiftUserRelationship) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(attendanceShiftUserRelationship)) {
      attendanceShiftUserRelationship = new AttendanceShiftUserRelationship();
    }
    return this.attendanceShiftUserRelationshipRepository.findByConditions(pageable, attendanceShiftUserRelationship);
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public AttendanceShiftUserRelationship findById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return this.attendanceShiftUserRelationshipRepository.getById(id);
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.attendanceShiftUserRelationshipRepository.removeByIds(idList);
  }

  @Override
  @Transactional
  public void createBatch(String shiftCode, Set<AttendanceShiftUserRelationship> shiftUserRelationshipSet) {

    this.saveValidate(shiftUserRelationshipSet);
    attendanceShiftUserRelationshipRepository.saveBatch(shiftUserRelationshipSet);
  }

  @Override
  public void deleteByShiftCode(String shiftCode) {
    if (StringUtils.isBlank(shiftCode)) {
      return;
    }
    attendanceShiftUserRelationshipRepository.deleteByShiftCode(shiftCode);
  }

  @Override
  public List<AttendanceShiftUserRelationship> findByShiftCode(String shiftCode) {
    if(StringUtils.isBlank(shiftCode)){
      return Lists.newArrayList();
    }
    return attendanceShiftUserRelationshipRepository.findByShiftCode(shiftCode);
  }

  /**
   * 保存前校验
   *
   * @param shiftUserRelationshipSet
   */
  private void saveValidate(Set<AttendanceShiftUserRelationship> shiftUserRelationshipSet) {
    Validate.notNull(shiftUserRelationshipSet, "保存关联用户信息时，对象不能为空");
    shiftUserRelationshipSet.forEach(this::createValidate);
  }

  /**
   * 创建验证
   *
   * @param attendanceShiftUserRelationship
   */
  private void createValidate(AttendanceShiftUserRelationship attendanceShiftUserRelationship) {
    Validate.notNull(attendanceShiftUserRelationship, "新增时，对象信息不能为空！");
    attendanceShiftUserRelationship.setId(null);
    Validate.notBlank(attendanceShiftUserRelationship.getShiftCode(), "新增数据时， 班次编码 不能为空！");
    Validate.notBlank(attendanceShiftUserRelationship.getUserCode(), "新增数据时， 导购编码 不能为空！");
    Validate.notBlank(attendanceShiftUserRelationship.getUserName(), "新增数据时， 导购名称 不能为空！");
    Validate.notBlank(attendanceShiftUserRelationship.getUserAccount(),"新增数据时， 导购账号 不能为空！");
    Validate.notBlank(attendanceShiftUserRelationship.getUserType(),"新增数据时， 用户类型 不能为空！");
  }
}

