package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftVoRepository;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceShiftVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftVo;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * 班次管理Vo Service接口实现类
 *
 * @Author dy
 * @DATE 2022/2/18
 **/
@Service("attendanceShiftVoService")
public class AttendanceShiftVoServiceImpl implements AttendanceShiftVoService {

  @Autowired
  private AttendanceShiftVoRepository attendanceShiftVoRepository;

  @Override
  public AttendanceShiftVo findDetailsById(String id) {
    if (StringUtils.isBlank(id)) {
      return null;
    }
    return attendanceShiftVoRepository.findDetailsById(id);
  }

  @Override
  public AttendanceShiftVo findDetailsByShiftCode(String shiftCode) {
    if (StringUtils.isBlank(shiftCode)) {
      return null;
    }
    return attendanceShiftVoRepository.findDetailsByShiftCode(shiftCode);
  }

  @Override
  public Page<AttendanceShiftVo> findDetailsByConditions(Pageable pageable, ShiftConditionDto dto) {
    ObjectUtils.defaultIfNull(pageable, PageRequest.of(0, 50));
    if (Objects.isNull(dto)) {
      dto = new ShiftConditionDto();
    }
    return this.attendanceShiftVoRepository.findDetailsByConditions(pageable, dto);
  }
}
