/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceShiftApplicationVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/attendance/shiftApplication"})
@Api(tags={"\u6392\u73ed\u7533\u8bf7:AttendanceShiftApplicationVo:\u6392\u73ed\u7533\u8bf7"})
public class AttendanceShiftApplicationVoController {
    private static final Logger log = LoggerFactory.getLogger(AttendanceShiftApplicationVoController.class);
    @Autowired
    private AttendanceShiftApplicationVoService attendanceShiftApplicationVoService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findDetailsByConditions"})
    public Result<Page<AttendanceShiftApplicationVo>> findDetailsByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u4e0a\u73ed\u73ed\u6b21\u7ba1\u7406") ShiftApplicationConditionDto dto) {
        try {
            Page page = this.attendanceShiftApplicationVoService.findDetailsByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e\u8be6\u60c5(\u5305\u542b\u5173\u8054\u6570\u636e\uff09")
    @GetMapping(value={"findDetailsById"})
    public Result<AttendanceShiftApplicationVo> findDetailsById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findDetailsById(id);
            return Result.ok((Object)attendanceShiftApplicationVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7f16\u7801\u67e5\u8be2\u5355\u6761\u6570\u636e\u8be6\u60c5(\u5305\u542b\u5173\u8054\u6570\u636e\uff09")
    @GetMapping(value={"findDetailsByApplyCode"})
    public Result<AttendanceShiftApplicationVo> findDetailsByApplyCode(@RequestParam(value="shiftCode") @ApiParam(name="shiftCode", value="\u7533\u8bf7\u7f16\u7801") String applyCode) {
        try {
            AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findDetailsByApplyCode(applyCode);
            return Result.ok((Object)attendanceShiftApplicationVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u548c\u7533\u8bf7\u5468\u671f\u67e5\u8be2\u7533\u8bf7\u8be6\u60c5\uff0capplyPeriodDate\u53ef\u9009\u5468\u671f\u5185\u7684\u4efb\u610f\u4e00\u5929(\u5305\u542b\u5173\u8054\u6570\u636e\uff09")
    @GetMapping(value={"findByCurrentUserAndApplyPeriodDate"})
    public Result<AttendanceShiftApplicationVo> findByCurrentUserAndApplyPeriodDate(@RequestParam(value="applyPeriodDate") @ApiParam(name="applyPeriodDate", value="\u7533\u8bf7\u5468\u671f\u5185\u7684\u4efb\u610f\u4e00\u5929") @DateTimeFormat(pattern="yyyy-MM-dd") Date applyPeriodDate) {
        try {
            AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findByCurrentUserAndApplyPeriodDate(applyPeriodDate);
            return Result.ok((Object)attendanceShiftApplicationVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5bfc\u8d2d\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u6392\u73ed\u8ba1\u5212")
    @GetMapping(value={"findByCurrentUserAndDate"})
    public Result<AttendanceShiftApplicationVo> findByCurrentUserAndDate(@RequestParam(value="date") @ApiParam(name="date", value="\u67e5\u8be2\u65e5\u671f") @DateTimeFormat(pattern="yyyy-MM-dd") Date date) {
        try {
            AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.attendanceShiftApplicationVoService.findByCurrentUserAndDate(date);
            return Result.ok((Object)attendanceShiftApplicationVo);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

