/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftService;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftDto;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/attendance/shift"})
@Api(tags={"\u4e0a\u73ed\u73ed\u6b21\u7ba1\u7406:AttendanceShift:\u4e0a\u73ed\u73ed\u6b21\u7ba1\u7406"})
public class AttendanceShiftController {
    private static final Logger log = LoggerFactory.getLogger(AttendanceShiftController.class);
    @Autowired
    private AttendanceShiftService attendanceShiftService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<AttendanceShift>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="dto", value="\u4e0a\u73ed\u73ed\u6b21\u7ba1\u7406") ShiftConditionDto dto) {
        try {
            Page<AttendanceShift> page = this.attendanceShiftService.findByConditions(pageable, dto);
            return Result.ok(page);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<AttendanceShift> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            AttendanceShift attendanceShift = this.attendanceShiftService.findById(id);
            return Result.ok((Object)((Object)attendanceShift));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<AttendanceShift> create(@ApiParam(name="attendanceShift", value="\u4e0a\u73ed\u73ed\u6b21\u7ba1\u7406") @RequestBody AttendanceShiftDto attendanceShiftDto) {
        try {
            AttendanceShift result = this.attendanceShiftService.create(attendanceShiftDto);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<AttendanceShift> update(@ApiParam(name="attendanceShift", value="\u4e0a\u73ed\u73ed\u6b21\u7ba1\u7406") @RequestBody AttendanceShiftDto attendanceShiftDto) {
        try {
            AttendanceShift result = this.attendanceShiftService.update(attendanceShiftDto);
            return Result.ok((Object)((Object)result));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="idList") List<String> idList) {
        try {
            this.attendanceShiftService.delete(idList);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findByCurrentUser"})
    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u767b\u5f55\u7528\u6237\u67e5\u8be2\u53ef\u7528\u7684\u73ed\u6b21")
    public Result<List<AttendanceShift>> findByCurrentUser() {
        try {
            List<AttendanceShift> attendanceShiftList = this.attendanceShiftService.findByCurrentUser();
            return Result.ok(attendanceShiftList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @GetMapping(value={"findByUserAccount"})
    @ApiOperation(value="\u6839\u636e\u7528\u6237\u8d26\u53f7\u67e5\u8be2\u53ef\u7528\u7684\u73ed\u6b21")
    public Result<List<AttendanceShift>> findByUserAccount(@RequestParam(value="userAccount") @ApiParam(name="userAccount", value="\u7528\u6237\u8d26\u53f7") String userAccount) {
        try {
            List<AttendanceShift> attendanceShiftList = this.attendanceShiftService.findByUserAccount(userAccount);
            return Result.ok(attendanceShiftList);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

