/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.local.mapper.AttendanceShiftMapper;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class AttendanceShiftRepository
extends ServiceImpl<AttendanceShiftMapper, AttendanceShift> {
    @Autowired
    private AttendanceShiftMapper attendanceShiftMapper;

    public Page<AttendanceShift> findByConditions(Pageable pageable, ShiftConditionDto dto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<AttendanceShift> pageList = this.attendanceShiftMapper.findByConditions((Page<AttendanceShift>)page, dto);
        return pageList;
    }

    public AttendanceShift findById(String id) {
        return (AttendanceShift)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).one());
    }

    public AttendanceShift findByShiftCode(String shiftCode) {
        return (AttendanceShift)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AttendanceShift::getShiftCode, (Object)shiftCode)).one());
    }

    public List<AttendanceShift> findByShiftTypeAndEnable(String shiftType) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AttendanceShift::getShiftType, (Object)shiftType)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }

    public List<AttendanceShift> findByShiftTypeAndEnableAndIdNot(String shiftType, String id) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AttendanceShift::getShiftType, (Object)shiftType)).ne(UuidEntity::getId, (Object)id)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }

    public List<AttendanceShift> findByShoppingGuideSelectMethodAndEnable(String shoppingGuideSelectMethod) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(AttendanceShift::getShoppingGuideSelectMethod, (Object)shoppingGuideSelectMethod)).eq(UuidFlagOpEntity::getEnableStatus, (Object)EnableStatusEnum.ENABLE.getCode())).list();
    }
}

