/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.service.internal;

import com.biz.crm.cps.business.attendance.local.entity.AttendanceClockPictureRelationship;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceClockPictureRelationshipRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceClockPictureRelationshipService;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockPictureDto;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceClockPictureRelationshipService")
public class AttendanceClockPictureRelationshipServiceImpl
implements AttendanceClockPictureRelationshipService {
    @Autowired
    private AttendanceClockPictureRelationshipRepository attendanceClockPictureRelationshipRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    private void createValidate(AttendanceClockPictureRelationship attendanceClockPictureRelationship) {
        Validate.notNull((Object)((Object)attendanceClockPictureRelationship), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceClockPictureRelationship.getPictureAddress(), (String)"\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceClockPictureRelationship.getPictureName(), (String)"\u56fe\u7247\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        attendanceClockPictureRelationship.setId(null);
    }

    @Override
    @Transactional
    public void createBatch(String clockId, Set<AttendanceClockPictureDto> attendanceClockPictures) {
        if (CollectionUtils.isEmpty(attendanceClockPictures)) {
            return;
        }
        Validate.notBlank((CharSequence)clockId, (String)"\u5173\u8054\u7684\u6253\u5361\u8bb0\u5f55Id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set pictures = (Set)this.nebulaToolkitService.copyCollectionByBlankList(attendanceClockPictures, AttendanceClockPictureDto.class, AttendanceClockPictureRelationship.class, HashSet.class, ArrayList.class, new String[0]);
        pictures.stream().forEach(p -> {
            p.setAttendanceClockId(clockId);
            this.createValidate((AttendanceClockPictureRelationship)((Object)p));
        });
        this.attendanceClockPictureRelationshipRepository.deleteByAttendanceClockId(clockId);
        this.attendanceClockPictureRelationshipRepository.saveOrUpdateBatch(pictures);
    }
}

