/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceClock;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceClockRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceClockPictureRelationshipService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceClockService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftApplicationService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftPlanService;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ClockStatusEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ClockTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftApplicationAuditStatusEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftPlanTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockConditionDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceClockDto;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.terminal.sdk.service.TerminalVoService;
import com.biz.crm.mdm.business.terminal.sdk.vo.TerminalVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceClockService")
public class AttendanceClockServiceImpl
implements AttendanceClockService {
    @Autowired
    private AttendanceClockRepository attendanceClockRepository;
    @Autowired
    private AttendanceShiftPlanService attendanceShiftPlanService;
    @Autowired
    private AttendanceShiftApplicationService attendanceShiftApplicationService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private AttendanceClockPictureRelationshipService attendanceClockPictureRelationshipService;
    @Autowired
    private TerminalVoService terminalVoService;
    private static final double MAXIMUM_CLOCK_DISTANCE = 1000.0;

    @Override
    public Page<AttendanceClock> findByConditions(Pageable pageable, AttendanceClockConditionDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AttendanceClockConditionDto();
        }
        return this.attendanceClockRepository.findByConditions(pageable, dto);
    }

    @Override
    public AttendanceClock findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (AttendanceClock)((Object)this.attendanceClockRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.attendanceClockRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public AttendanceClock create(AttendanceClockDto attendanceClockDto) {
        this.clockValidate(attendanceClockDto);
        Date now = new Date();
        String clockType = attendanceClockDto.getClockType();
        AttendanceClock attendanceClock = new AttendanceClock();
        attendanceClock.setLatitude(attendanceClockDto.getLatitude());
        attendanceClock.setLongitude(attendanceClockDto.getLongitude());
        if (ClockTypeEnum.CLOCK_IN.getDictCode().equals(clockType)) {
            this.handleClockIn(attendanceClock);
        } else if (ClockTypeEnum.CLOCK_OUT.getDictCode().equals(clockType)) {
            this.handleClockOut(attendanceClock);
        } else {
            throw new IllegalArgumentException("\u6253\u5361\u7c7b\u578b\u53c2\u6570\u9519\u8bef");
        }
        attendanceClock.setClockDate(now);
        BeanUtils.copyProperties((Object)attendanceClockDto, (Object)((Object)attendanceClock));
        attendanceClock.setTenantCode(TenantUtils.getTenantCode());
        attendanceClock.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        attendanceClock.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        attendanceClock.setCreateAccount(this.loginUserService.getLoginAccountName());
        attendanceClock.setCreateTime(now);
        attendanceClock.setModifyAccount(this.loginUserService.getLoginAccountName());
        attendanceClock.setModifyTime(now);
        this.attendanceClockRepository.saveOrUpdate((Object)attendanceClock);
        this.attendanceClockPictureRelationshipService.createBatch(attendanceClock.getId(), attendanceClockDto.getPictures());
        return attendanceClock;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleClockIn(AttendanceClock attendanceClock) {
        AttendanceShiftApplication application;
        Date now = new Date();
        Date previousDays = DateUtils.addDays((Date)now, (int)-1);
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        String account = loginUser.getConsumerCode();
        AttendanceShiftPlan plan = null;
        AttendanceShiftPlan previousDayPlan = this.attendanceShiftPlanService.findByUserAccountAndSchedulingDate(account, previousDays);
        AttendanceShiftPlan todayPlan = this.attendanceShiftPlanService.findByUserAccountAndSchedulingDate(account, now);
        if (Objects.nonNull((Object)previousDayPlan) && Objects.nonNull(previousDayPlan.getWorkEndDate()) && now.before(previousDayPlan.getWorkEndDate()) && Objects.nonNull((Object)(application = this.attendanceShiftApplicationService.findByApplyCode(plan.getApplyCode()))) && ShiftApplicationAuditStatusEnum.PASS.getDictCode().equals(application.getAuditStatus())) {
            AttendanceClock previousDayPlanClock = this.attendanceClockRepository.findByUserAccountAndAttendanceDateAndClockType(account, previousDayPlan.getSchedulingDate(), ClockTypeEnum.CLOCK_IN.getDictCode());
            AttendanceShiftPlan attendanceShiftPlan = plan = previousDayPlanClock == null ? previousDayPlan : null;
        }
        if (plan == null && Objects.nonNull((Object)todayPlan)) {
            AttendanceClock todayPlanClock = this.attendanceClockRepository.findByUserAccountAndAttendanceDateAndClockType(account, todayPlan.getSchedulingDate(), ClockTypeEnum.CLOCK_IN.getDictCode());
            Validate.isTrue((todayPlanClock == null ? 1 : 0) != 0, (String)String.format("\u60a8\u5728%tF \u7684\u73ed\u6b21 %s\u5df2\u7ecf\u6253\u8fc7\u4e0a\u73ed\u5361", todayPlan.getSchedulingDate(), todayPlan.getShiftName()), (Object[])new Object[0]);
            plan = todayPlan;
        }
        Validate.notNull(plan, (String)"\u5f53\u524d\u6682\u65e0\u6392\u73ed\u8ba1\u5212", (Object[])new Object[0]);
        application = this.attendanceShiftApplicationService.findByApplyCode(plan.getApplyCode());
        Validate.isTrue((application != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6682\u672a\u6392\u73ed\u8ba1\u5212\uff0c\u8bf7\u5148\u521b\u5efa", (Object[])new Object[0]);
        Validate.isTrue((boolean)ShiftApplicationAuditStatusEnum.PASS.getDictCode().equals(application.getAuditStatus()), (String)"\u6392\u73ed\u8ba1\u5212\u7533\u8bf7\u6b63\u5728\u5ba1\u6838\u4e2d\u6216\u88ab\u62d2\u7edd\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4e1a\u52a1\u5458\u5904\u7406", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)plan.getShiftPlanType(), (CharSequence[])new CharSequence[]{ShiftPlanTypeEnum.MORNING_SHIFT.getDictCode(), ShiftPlanTypeEnum.MIDDLE_SHIFT.getDictCode(), ShiftPlanTypeEnum.NIGHT_SHIFT.getDictCode()}), (String)"\u5f53\u524d\u73ed\u6b21\u7c7b\u578b\u4e0d\u9700\u8981\u6253\u5361", (Object[])new Object[0]);
        this.clockAddressValid(plan.getTerminalCode(), attendanceClock);
        attendanceClock.setShiftPlanId(plan.getId());
        attendanceClock.setAttendanceDate(plan.getSchedulingDate());
        attendanceClock.setUserAccount(loginUser.getConsumerCode());
        attendanceClock.setUserCode(loginUser.getAccount());
        attendanceClock.setUserName(loginUser.getConsumerName());
        Date workStartDate = plan.getWorkStartDate();
        Date latestSignInDate = plan.getLatestSignInDate();
        if (now.before(workStartDate) || latestSignInDate != null && now.before(latestSignInDate)) {
            attendanceClock.setClockStatus(ClockStatusEnum.NORMAL.getDictCode());
        } else {
            attendanceClock.setClockStatus(ClockStatusEnum.LATE.getDictCode());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleClockOut(AttendanceClock attendanceClock) {
        Date now = new Date();
        Date previousDays = DateUtils.addDays((Date)now, (int)-1);
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        String account = loginUser.getConsumerCode();
        AttendanceShiftPlan plan = null;
        AttendanceClock existClock = null;
        AttendanceShiftPlan previousDayPlan = this.attendanceShiftPlanService.findByUserAccountAndSchedulingDate(account, previousDays);
        AttendanceShiftPlan todayPlan = this.attendanceShiftPlanService.findByUserAccountAndSchedulingDate(account, now);
        if (Objects.nonNull((Object)previousDayPlan) && Objects.nonNull(previousDayPlan.getWorkEndDate()) && now.before(previousDayPlan.getWorkEndDate())) {
            existClock = this.attendanceClockRepository.findByUserAccountAndAttendanceDateAndClockType(account, previousDayPlan.getSchedulingDate(), ClockTypeEnum.CLOCK_OUT.getDictCode());
            plan = previousDayPlan;
        }
        if (plan == null && Objects.nonNull((Object)todayPlan)) {
            existClock = this.attendanceClockRepository.findByUserAccountAndAttendanceDateAndClockType(account, todayPlan.getSchedulingDate(), ClockTypeEnum.CLOCK_OUT.getDictCode());
            plan = todayPlan;
        }
        Validate.notNull(plan, (String)"\u5f53\u524d\u6682\u65e0\u6392\u73ed\u8ba1\u5212", (Object[])new Object[0]);
        AttendanceShiftApplication application = this.attendanceShiftApplicationService.findByApplyCode(plan.getApplyCode());
        Validate.isTrue((application != null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6682\u672a\u6392\u73ed\u8ba1\u5212\uff0c\u8bf7\u5148\u521b\u5efa", (Object[])new Object[0]);
        Validate.isTrue((boolean)ShiftApplicationAuditStatusEnum.PASS.getDictCode().equals(application.getAuditStatus()), (String)"\u6392\u73ed\u8ba1\u5212\u7533\u8bf7\u6b63\u5728\u5ba1\u6838\u4e2d\u6216\u88ab\u62d2\u7edd\uff0c\u8bf7\u8054\u7cfb\u76f8\u5173\u4e1a\u52a1\u5458\u5904\u7406", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equalsAny((CharSequence)plan.getShiftPlanType(), (CharSequence[])new CharSequence[]{ShiftPlanTypeEnum.MORNING_SHIFT.getDictCode(), ShiftPlanTypeEnum.MIDDLE_SHIFT.getDictCode(), ShiftPlanTypeEnum.NIGHT_SHIFT.getDictCode()}), (String)"\u5f53\u524d\u73ed\u6b21\u7c7b\u578b\u4e0d\u9700\u8981\u6253\u5361", (Object[])new Object[0]);
        this.clockAddressValid(plan.getTerminalCode(), attendanceClock);
        AttendanceClock clockIn = this.attendanceClockRepository.findByUserAccountAndAttendanceDateAndClockType(account, plan.getSchedulingDate(), ClockTypeEnum.CLOCK_IN.getDictCode());
        Validate.notNull((Object)((Object)clockIn), (String)"\u5f53\u524d\u672a\u6253\u4e0a\u73ed\u5361\uff0c\u8bf7\u5148\u5b8c\u6210\u4e0a\u73ed\u5361\u540e\u91cd\u8bd5", (Object[])new Object[0]);
        attendanceClock.setShiftPlanId(plan.getId());
        attendanceClock.setAttendanceDate(plan.getSchedulingDate());
        attendanceClock.setUserAccount(loginUser.getConsumerCode());
        attendanceClock.setUserCode(loginUser.getAccount());
        attendanceClock.setUserName(loginUser.getConsumerName());
        if (existClock != null) {
            attendanceClock.setId(existClock.getId());
        }
        Date workEndDate = plan.getWorkEndDate();
        Date earliestSignBackDate = plan.getEarliestSignBackDate();
        if (earliestSignBackDate != null && now.after(earliestSignBackDate) || now.after(workEndDate)) {
            attendanceClock.setClockStatus(ClockStatusEnum.NORMAL.getDictCode());
        } else {
            attendanceClock.setClockStatus(ClockStatusEnum.LEAVE_EARLY.getDictCode());
        }
    }

    @Override
    public List<AttendanceClock> findByShiftPlanId(String shiftPlanId) {
        if (StringUtils.isBlank((CharSequence)shiftPlanId)) {
            return Lists.newArrayList();
        }
        return this.attendanceClockRepository.findByShiftPlanId(shiftPlanId);
    }

    private void clockValidate(AttendanceClockDto attendanceClockDto) {
        Validate.notBlank((CharSequence)attendanceClockDto.getClockType(), (String)"\u6253\u5361\u793a\uff0c\u6253\u5361\u7c7b\u578b\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceClockDto.getClockAddress(), (String)"\u6253\u5361\u65f6\uff0c \u6253\u5361\u8be6\u7ec6\u5730\u5740\u5730\u5740 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceClockDto.getClockAddressCode(), (String)"\u6253\u5361\u65f6\uff0c\u6253\u5361\u8be6\u7ec6\u5730\u5740\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceClockDto.getLatitude(), (String)"\u6253\u5361\u65f6\uff0c \u6253\u5361\u7eac\u5ea6 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceClockDto.getLongitude(), (String)"\u6253\u5361\u65f6\uff0c \u6253\u5361\u7ecf\u5ea6 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void clockAddressValid(String terminalCode, AttendanceClock attendanceClock) {
        List terminalVos = this.terminalVoService.findMainDetailsByTerminalCodes(Arrays.asList(terminalCode));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)terminalVos) ? 1 : 0) != 0, (String)"\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u7ec8\u7aef\u4fe1\u606f", (Object[])new Object[0]);
        TerminalVo terminalVo = (TerminalVo)terminalVos.get(0);
        Validate.notNull((Object)terminalVo, (String)"\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u7ec8\u7aef\u4fe1\u606f", (Object[])new Object[0]);
        BigDecimal terminalLongitude = terminalVo.getLongitude();
        BigDecimal terminalLatitude = terminalVo.getLatitude();
        Validate.isTrue((terminalLatitude != null && terminalLongitude != null ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7684\u7ecf\u5ea6\uff0c\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        GlobalCoordinates source = new GlobalCoordinates(terminalLatitude.doubleValue(), terminalLongitude.doubleValue());
        GlobalCoordinates target = new GlobalCoordinates(attendanceClock.getLatitude().doubleValue(), attendanceClock.getLongitude().doubleValue());
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(Ellipsoid.Sphere, source, target);
        double distance = Math.abs(geoCurve.getEllipsoidalDistance());
        Validate.isTrue((distance <= 1000.0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u4e0d\u5728\u7b7e\u5230\u8303\u56f4\u5185", (Object[])new Object[0]);
    }
}

