/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceClock;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceDetailSettlement;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceClockRepository;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceDetailSettlementRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceDetailSettlementService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftApplicationService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftPlanService;
import com.biz.crm.cps.business.attendance.sdk.common.enums.AttendanceStatusEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ClockStatusEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ClockTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftApplicationAuditStatusEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftPlanTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceDetailConditionDto;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="attendanceDetailSettlementService")
public class AttendanceDetailSettlementServiceImpl
implements AttendanceDetailSettlementService {
    @Autowired
    private AttendanceDetailSettlementRepository attendanceDetailSettlementRepository;
    @Autowired
    private AttendanceShiftPlanService attendanceShiftPlanService;
    @Autowired
    private AttendanceShiftApplicationService attendanceShiftApplicationService;
    @Autowired
    private AttendanceClockRepository attendanceClockRepository;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    public Page<AttendanceDetailSettlement> findByConditions(Pageable pageable, AttendanceDetailConditionDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new AttendanceDetailConditionDto();
        }
        return this.attendanceDetailSettlementRepository.findByConditions(pageable, dto);
    }

    @Override
    public AttendanceDetailSettlement findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (AttendanceDetailSettlement)((Object)this.attendanceDetailSettlementRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.attendanceDetailSettlementRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void hanlderAttendanceReportByDate(Date date) {
        Validate.notNull((Object)date, (String)"\u6307\u5b9a\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date now = new Date();
        this.attendanceDetailSettlementRepository.deleteByAttendanceDate(DateUtils.truncate((Date)date, (int)5));
        List<AttendanceShiftPlan> plans = this.attendanceShiftPlanService.findBySchedulingDateAndAuditStatus(date, ShiftApplicationAuditStatusEnum.PASS.getDictCode());
        if (CollectionUtils.isEmpty(plans)) {
            return;
        }
        ArrayList attendanceDetailSettlements = Lists.newArrayList();
        ArrayList notAttendanceClocks = Lists.newArrayList();
        for (AttendanceShiftPlan plan : plans) {
            if (ShiftPlanTypeEnum.REST_DAY.getDictCode().equals(plan.getShiftPlanType())) continue;
            AttendanceDetailSettlement attendanceDetailSettlement = new AttendanceDetailSettlement();
            attendanceDetailSettlement.setCreateAccount("admin");
            attendanceDetailSettlement.setModifyAccount("admin");
            attendanceDetailSettlement.setCreateTime(now);
            attendanceDetailSettlement.setModifyTime(now);
            attendanceDetailSettlement.setTenantCode(TenantUtils.getTenantCode());
            attendanceDetailSettlement.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            attendanceDetailSettlement.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            AttendanceShiftApplication application = this.attendanceShiftApplicationService.findByApplyCode(plan.getApplyCode());
            attendanceDetailSettlement.setAttendanceDate(plan.getSchedulingDate());
            attendanceDetailSettlement.setUserAccount(application.getUserAccount());
            attendanceDetailSettlement.setUserCode(application.getUserCode());
            attendanceDetailSettlement.setUserName(application.getUserName());
            attendanceDetailSettlement.setContactPhone(application.getContactPhone());
            attendanceDetailSettlement.setShiftPlanType(plan.getShiftPlanType());
            attendanceDetailSettlement.setShiftPlanName(plan.getShiftName());
            attendanceDetailSettlement.setGoalWorkHours(BigDecimal.ZERO);
            attendanceDetailSettlement.setRealWorkHours(BigDecimal.ZERO);
            List userVos = this.userFeignVoService.findByUserNames(Arrays.asList(application.getUserAccount()));
            if (!CollectionUtils.isEmpty((Collection)userVos) && userVos.get(0) != null) {
                UserVo userVo = (UserVo)userVos.get(0);
                attendanceDetailSettlement.setPositionCode(userVo.getPositionLevelCode());
                attendanceDetailSettlement.setPositionName(userVo.getPositionLevelName());
                attendanceDetailSettlement.setOrgCode(userVo.getOrgCode());
                attendanceDetailSettlement.setOrgName(userVo.getOrgName());
            }
            if (ShiftPlanTypeEnum.DAY_COMPENSATORY_LEAVE.getDictCode().equals(plan.getShiftPlanType())) {
                attendanceDetailSettlement.setCompensatoryLeaveLength(this.calculateWorkHours(plan.getWorkStartDate(), plan.getWorkEndDate()));
                attendanceDetailSettlement.setAttendanceStatus(AttendanceStatusEnum.DONT_NEED_CLOCK.getDictCode());
                attendanceDetailSettlements.add(attendanceDetailSettlement);
                continue;
            }
            attendanceDetailSettlement.setGoalWorkHours(plan.getNormalWorkHours());
            attendanceDetailSettlement.setCompensatoryLeaveLength(plan.getCompensatoryLeaveLength());
            List<Object> attendanceClocks = this.attendanceClockRepository.findByShiftPlanId(plan.getId());
            attendanceClocks = attendanceClocks == null ? Lists.newArrayList() : attendanceClocks;
            Set clockTypeSet = attendanceClocks.stream().map(AttendanceClock::getClockType).collect(Collectors.toSet());
            for (ClockTypeEnum value : ClockTypeEnum.values()) {
                if (clockTypeSet.contains(value.getDictCode())) continue;
                AttendanceClock attendanceClock = new AttendanceClock();
                attendanceClock.setClockType(value.getDictCode());
                attendanceClock.setClockStatus(ClockStatusEnum.NOT_CLOCK.getDictCode());
                attendanceClock.setAttendanceDate(plan.getSchedulingDate());
                attendanceClock.setUserAccount(application.getUserAccount());
                attendanceClock.setTenantCode(application.getTenantCode());
                attendanceClock.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                attendanceClock.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                attendanceClock.setCreateTime(now);
                attendanceClock.setModifyTime(now);
                attendanceClock.setCreateAccount("admin");
                attendanceClock.setModifyAccount("admin");
                notAttendanceClocks.add(attendanceClock);
            }
            if (CollectionUtils.isEmpty(attendanceClocks)) {
                attendanceDetailSettlement.setAttendanceStatus(AttendanceStatusEnum.NOT_CLOCK.getDictCode());
                attendanceDetailSettlements.add(attendanceDetailSettlement);
                continue;
            }
            String clockInStatus = null;
            String clockOutStatus = null;
            Date clockInDate = null;
            Date clockOutDate = null;
            for (AttendanceClock attendanceClock : attendanceClocks) {
                if (ClockTypeEnum.CLOCK_IN.getDictCode().equals(attendanceClock.getClockType())) {
                    attendanceDetailSettlement.setSignInDate(attendanceClock.getClockDate());
                    clockInDate = attendanceClock.getClockDate();
                    clockInStatus = attendanceClock.getClockStatus();
                }
                if (ClockTypeEnum.CLOCK_OUT.getDictCode().equals(attendanceClock.getClockType())) {
                    attendanceDetailSettlement.setSignBackDate(attendanceClock.getClockDate());
                    clockOutDate = attendanceClock.getClockDate();
                    clockOutStatus = attendanceClock.getClockStatus();
                }
                attendanceDetailSettlement.setAddressCode(attendanceClock.getClockAddressCode());
                attendanceDetailSettlement.setAddress(attendanceClock.getClockAddress());
                attendanceDetailSettlement.setLatitude(attendanceClock.getLatitude());
                attendanceDetailSettlement.setLongitude(attendanceClock.getLongitude());
            }
            attendanceDetailSettlement.setAttendanceStatus(this.getAttendanceStatus(clockInStatus, clockOutStatus).getDictCode());
            if (clockInDate != null && clockOutDate != null) {
                attendanceDetailSettlement.setRealWorkHours(this.calculateWorkHours(clockInDate, clockOutDate));
            }
            attendanceDetailSettlements.add(attendanceDetailSettlement);
        }
        this.attendanceClockRepository.saveBatch(notAttendanceClocks);
        this.attendanceDetailSettlementRepository.saveBatch(attendanceDetailSettlements);
    }

    @Transactional(rollbackFor={Exception.class})
    @DynamicTaskService(cornExpression="0 0 0 * * ?", taskDesc="\u6bcf\u65e5\u751f\u6210\u524d\u5929\u7684\u8003\u52e4\u6570\u636e")
    public void attendanceSettleTask() {
        Date now = new Date();
        Date theDayBefore = DateUtils.addDays((Date)now, (int)-2);
        this.hanlderAttendanceReportByDate(theDayBefore);
    }

    private AttendanceStatusEnum getAttendanceStatus(String clockInStatus, String clockOutStatus) {
        AttendanceStatusEnum attendanceStatusEnum = null;
        attendanceStatusEnum = attendanceStatusEnum == null && StringUtils.isAllBlank((CharSequence[])new CharSequence[]{clockInStatus, clockOutStatus}) ? AttendanceStatusEnum.NOT_CLOCK : attendanceStatusEnum;
        attendanceStatusEnum = attendanceStatusEnum == null && StringUtils.isBlank((CharSequence)clockInStatus) ? AttendanceStatusEnum.NOT_CLOCK_IN : attendanceStatusEnum;
        attendanceStatusEnum = attendanceStatusEnum == null && StringUtils.isBlank((CharSequence)clockOutStatus) ? AttendanceStatusEnum.NOT_CLOCK_OUT : attendanceStatusEnum;
        attendanceStatusEnum = attendanceStatusEnum == null && StringUtils.equals((CharSequence)clockInStatus, (CharSequence)ClockStatusEnum.LATE.getDictCode()) && StringUtils.equals((CharSequence)clockOutStatus, (CharSequence)ClockStatusEnum.LEAVE_EARLY.getDictCode()) ? AttendanceStatusEnum.LATE_AND_LEAVE_EARLY : attendanceStatusEnum;
        attendanceStatusEnum = attendanceStatusEnum == null && StringUtils.equals((CharSequence)clockInStatus, (CharSequence)ClockStatusEnum.LATE.getDictCode()) ? AttendanceStatusEnum.LATE : attendanceStatusEnum;
        attendanceStatusEnum = attendanceStatusEnum == null && StringUtils.equals((CharSequence)clockOutStatus, (CharSequence)ClockStatusEnum.LEAVE_EARLY.getDictCode()) ? AttendanceStatusEnum.LEAVE_EARLY : attendanceStatusEnum;
        AttendanceStatusEnum attendanceStatusEnum2 = attendanceStatusEnum = attendanceStatusEnum == null && StringUtils.equals((CharSequence)clockInStatus, (CharSequence)ClockStatusEnum.NORMAL.getDictCode()) && StringUtils.equals((CharSequence)clockOutStatus, (CharSequence)ClockStatusEnum.NORMAL.getDictCode()) ? AttendanceStatusEnum.NORMAL : attendanceStatusEnum;
        if (attendanceStatusEnum == null) {
            attendanceStatusEnum = AttendanceStatusEnum.NOT_CLOCK;
        }
        return attendanceStatusEnum;
    }

    private BigDecimal calculateWorkHours(Date start, Date end) {
        BigDecimal s = BigDecimal.valueOf(start.getTime());
        BigDecimal e = BigDecimal.valueOf(end.getTime());
        BigDecimal hourMinutes = BigDecimal.valueOf(3600000L);
        BigDecimal totalMinutes = e.subtract(s);
        return totalMinutes.divide(hourMinutes, 2, 4);
    }
}

