/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftApplicationRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftApplicationService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftPlanService;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftApplicationAuditStatusEnum;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftApplicationApproveDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftApplicationDto;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="AttendanceShiftApplicationService")
public class AttendanceShiftApplicationServiceImpl
implements AttendanceShiftApplicationService {
    @Autowired
    private AttendanceShiftApplicationRepository attendanceShiftApplicationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private AttendanceShiftPlanService attendanceShiftPlanService;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    public Page<AttendanceShiftApplication> findByConditions(Pageable pageable, ShiftApplicationConditionDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ShiftApplicationConditionDto();
        }
        return this.attendanceShiftApplicationRepository.findByConditions(pageable, dto);
    }

    @Override
    public AttendanceShiftApplication findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (AttendanceShiftApplication)((Object)this.attendanceShiftApplicationRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public AttendanceShiftApplication create(AttendanceShiftApplicationDto attendanceShiftApplicationDto) {
        AttendanceShiftApplication attendanceShiftApplication = (AttendanceShiftApplication)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)attendanceShiftApplicationDto, AttendanceShiftApplication.class, HashSet.class, ArrayList.class, new String[0]));
        AttendanceShiftApplication current = this.createForm(attendanceShiftApplication);
        this.createBusinessValidate(attendanceShiftApplicationDto);
        this.attendanceShiftApplicationRepository.saveOrUpdate((Object)current);
        List shiftPlanDtos = attendanceShiftApplicationDto.getShiftPlans();
        shiftPlanDtos.stream().forEach(o -> o.setEffectiveDate(Boolean.valueOf(o.getSchedulingDate().compareTo(DateUtils.truncate((Date)current.getApplyDate(), (int)5)) >= 0)));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)shiftPlanDtos) ? 1 : 0) != 0, (String)"\u6392\u73ed\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceShiftPlanService.createBatch(current.getApplyCode(), shiftPlanDtos);
        return current;
    }

    @Override
    public AttendanceShiftApplication createForm(AttendanceShiftApplication attendanceShiftApplication) {
        LoginUserDetailsForCPS loginDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginDetails, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        attendanceShiftApplication.setUserAccount(loginDetails.getConsumerCode());
        attendanceShiftApplication.setUserType(loginDetails.getUsertype());
        attendanceShiftApplication.setUserCode(loginDetails.getAccount());
        attendanceShiftApplication.setUserName(loginDetails.getConsumerName());
        List userVos = this.userFeignVoService.findByUserNames(Arrays.asList(loginDetails.getConsumerCode()));
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)userVos) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        UserVo userVo = (UserVo)userVos.get(0);
        attendanceShiftApplication.setOrgCode(userVo.getOrgCode());
        attendanceShiftApplication.setOrgName(userVo.getOrgName());
        this.createValidate(attendanceShiftApplication);
        Date now = new Date();
        attendanceShiftApplication.setCreateTime(now);
        attendanceShiftApplication.setModifyTime(now);
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Validate.notBlank((CharSequence)loginAccountName, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u8d26\u53f7", (Object[])new Object[0]);
        attendanceShiftApplication.setCreateAccount(loginAccountName);
        attendanceShiftApplication.setModifyAccount(loginAccountName);
        attendanceShiftApplication.setTenantCode(TenantUtils.getTenantCode());
        attendanceShiftApplication.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        attendanceShiftApplication.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        attendanceShiftApplication.setAuditDate(null);
        attendanceShiftApplication.setRejectedReason(null);
        attendanceShiftApplication.setAuditStatus(ShiftApplicationAuditStatusEnum.NO_AUDIT.getDictCode());
        attendanceShiftApplication.setApplyPeriod(this.findApplyPeriodByDate(attendanceShiftApplication.getApplyStartDate()));
        attendanceShiftApplication.setApplyDate(now);
        String applyCode = (String)this.generateCodeService.generateCode("PBSQ", 1).get(0);
        Validate.notBlank((CharSequence)applyCode, (String)"\u751f\u6210\u7533\u8bf7\u7f16\u7801\u5931\u8d25", (Object[])new Object[0]);
        AttendanceShiftApplication application = this.attendanceShiftApplicationRepository.findByApplyCode(applyCode);
        Validate.isTrue((boolean)Objects.isNull((Object)application), (String)"\u73ed\u6b21\u7533\u8bf7\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        attendanceShiftApplication.setApplyCode(applyCode);
        return attendanceShiftApplication;
    }

    @Override
    @Transactional
    public AttendanceShiftApplication update(AttendanceShiftApplicationDto attendanceShiftApplicationDto) {
        AttendanceShiftApplication attendanceShiftApplication = (AttendanceShiftApplication)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)attendanceShiftApplicationDto, AttendanceShiftApplication.class, HashSet.class, ArrayList.class, new String[0]));
        AttendanceShiftApplication current = this.updateForm(attendanceShiftApplication);
        this.attendanceShiftPlanService.deleteByApplyCode(current.getApplyCode());
        this.updateBusinessValidate(attendanceShiftApplicationDto);
        this.attendanceShiftApplicationRepository.saveOrUpdate((Object)current);
        List shiftPlanDtos = attendanceShiftApplicationDto.getShiftPlans();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)shiftPlanDtos) ? 1 : 0) != 0, (String)"\u6392\u73ed\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        shiftPlanDtos.stream().forEach(o -> o.setEffectiveDate(Boolean.valueOf(o.getSchedulingDate().compareTo(DateUtils.truncate((Date)current.getApplyDate(), (int)5)) >= 0)));
        this.attendanceShiftPlanService.createBatch(current.getApplyCode(), shiftPlanDtos);
        return current;
    }

    @Override
    public AttendanceShiftApplication updateForm(AttendanceShiftApplication attendanceShiftApplication) {
        this.updateValidate(attendanceShiftApplication);
        String shiftApplicationId = attendanceShiftApplication.getId();
        String applyCode = attendanceShiftApplication.getApplyCode();
        AttendanceShiftApplication current = null;
        if (StringUtils.isNotBlank((CharSequence)shiftApplicationId)) {
            current = this.attendanceShiftApplicationRepository.findById(shiftApplicationId);
        } else if (current == null && StringUtils.isNotBlank((CharSequence)applyCode)) {
            current = this.attendanceShiftApplicationRepository.findByApplyCode(applyCode);
        }
        Validate.notNull((Object)((Object)current), (String)"\u6ca1\u6709\u627e\u5230\u539f\u59cb\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        Validate.isTrue((!ShiftApplicationAuditStatusEnum.PASS.getDictCode().equals(current.getAuditStatus()) ? 1 : 0) != 0, (String)"\u8be5\u7533\u8bf7\u5df2\u7ecf\u5ba1\u6838\u901a\u8fc7\uff0c\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Date now = new Date();
        attendanceShiftApplication.setModifyTime(now);
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Validate.notBlank((CharSequence)loginAccountName, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u8d26\u53f7", (Object[])new Object[0]);
        attendanceShiftApplication.setModifyAccount(loginAccountName);
        if (ShiftApplicationAuditStatusEnum.NO_AUDIT.getDictCode().equals(current.getAuditStatus())) {
            if (ShiftApplicationAuditStatusEnum.PASS.getDictCode().equals(attendanceShiftApplication.getAuditStatus())) {
                Validate.isTrue((boolean)ShiftApplicationAuditStatusEnum.NO_AUDIT.getDictCode().equals(current.getAuditStatus()), (String)"\u53ea\u80fd\u901a\u8fc7\u5f85\u5ba1\u6838\u7684\u7533\u8bf7", (Object[])new Object[0]);
                current.setAuditStatus(ShiftApplicationAuditStatusEnum.PASS.getDictCode());
                current.setAuditDate(now);
            }
            if (ShiftApplicationAuditStatusEnum.REJECTED.getDictCode().equals(attendanceShiftApplication.getAuditStatus())) {
                current.setAuditStatus(ShiftApplicationAuditStatusEnum.REJECTED.getDictCode());
                current.setRejectedReason(attendanceShiftApplication.getRejectedReason());
                current.setAuditDate(now);
            }
        } else if (ShiftApplicationAuditStatusEnum.REJECTED.getDictCode().equals(current.getAuditStatus())) {
            current.setAuditDate(null);
            current.setRejectedReason(null);
            current.setAuditStatus(ShiftApplicationAuditStatusEnum.NO_AUDIT.getDictCode());
        } else {
            throw new IllegalArgumentException("\u5ba1\u6838\u72b6\u6001\u5f02\u5e38");
        }
        return current;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.attendanceShiftApplicationRepository.removeByIds(idList);
    }

    private void createValidate(AttendanceShiftApplication attendanceShiftApplication) {
        Validate.notNull((Object)((Object)attendanceShiftApplication), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        attendanceShiftApplication.setId(null);
        Validate.notNull((Object)attendanceShiftApplication.getApplyEndDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u6392\u73ed\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShiftApplication.getApplyStartDate(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u6392\u73ed\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftApplication.getUserCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u7533\u8bf7\u5bfc\u8d2d\u5458\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftApplication.getUserName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u7533\u8bf7\u5bfc\u8d2d\u5458\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftApplication.getUserAccount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u7533\u8bf7\u5bfc\u8d2d\u5458\u8d26\u53f7 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftApplication.getContactPhone(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7533\u8bf7\u5bfc\u8d2d\u5458\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
    }

    private void updateValidate(AttendanceShiftApplication attendanceShiftApplication) {
        Validate.notNull((Object)((Object)attendanceShiftApplication), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)attendanceShiftApplication.getId()) || StringUtils.isNotBlank((CharSequence)attendanceShiftApplication.getApplyCode()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cid\u548c\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShiftApplication.getAuditStatus(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c \u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void createBusinessValidate(AttendanceShiftApplicationDto attendanceShiftApplicationDto) {
        List shiftPlans = attendanceShiftApplicationDto.getShiftPlans();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)shiftPlans) && shiftPlans.size() <= 7 ? 1 : 0) != 0, (String)"\u6392\u73ed\u7533\u8bf7\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u6bcf\u6b21\u6700\u591a\u53ea\u80fd\u7533\u8bf7\u4e03\u5929\u7684\u6392\u73ed", (Object[])new Object[0]);
        Calendar applyStartDate = DateUtils.toCalendar((Date)attendanceShiftApplicationDto.getApplyStartDate());
        Calendar applyEndDate = DateUtils.toCalendar((Date)attendanceShiftApplicationDto.getApplyEndDate());
        Validate.isTrue((DateUtils.truncatedCompareTo((Calendar)applyStartDate, (Calendar)applyEndDate, (int)5) == -1 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u6392\u73ed\u7684\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u524d", (Object[])new Object[0]);
        Validate.isTrue((applyStartDate.get(7) == 2 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u6392\u73ed\u5f00\u59cb\u65f6\u95f4\u53ea\u80fd\u4e3a\u5468\u4e00", (Object[])new Object[0]);
        Validate.isTrue((applyEndDate.get(7) == 1 ? 1 : 0) != 0, (String)"\u7533\u8bf7\u6392\u73ed\u7ed3\u675f\u65f6\u95f4\u53ea\u80fd\u4e3a\u5468\u672b", (Object[])new Object[0]);
        Calendar thisWeekStart = Calendar.getInstance();
        thisWeekStart.set(7, 2);
        Calendar thisWeekEnd = Calendar.getInstance();
        thisWeekEnd.setFirstDayOfWeek(2);
        thisWeekEnd.set(7, 1);
        Calendar nextWeekStart = Calendar.getInstance();
        Date date = DateUtils.addWeeks((Date)thisWeekStart.getTime(), (int)1);
        nextWeekStart.setTime(date);
        LoginUserDetailsForCPS loginDetails = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginDetails, (String)"\u83b7\u53d6\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        String userAccount = loginDetails.getConsumerCode();
        if (DateUtils.isSameDay((Calendar)thisWeekStart, (Calendar)applyStartDate)) {
            Validate.isTrue((boolean)DateUtils.isSameDay((Calendar)applyEndDate, (Calendar)thisWeekEnd), (String)"\u7533\u8bf7\u672c\u5468\u6392\u73ed\u65f6,\u7533\u8bf7\u7ed3\u675f\u65f6\u95f4\u53ea\u80fd\u662f\u672c\u5468\u672b", (Object[])new Object[0]);
            AttendanceShiftApplication application = this.attendanceShiftApplicationRepository.findByUserAccountAndApplyPeriod(userAccount, this.findApplyPeriodByDate(thisWeekStart.getTime()));
            Validate.isTrue((boolean)Objects.isNull((Object)application), (String)"\u672c\u5468\u5df2\u7ecf\u7533\u8bf7\u8fc7", (Object[])new Object[0]);
        } else if (DateUtils.isSameDay((Calendar)nextWeekStart, (Calendar)applyStartDate)) {
            Date nextWeekEnd = DateUtils.addWeeks((Date)thisWeekEnd.getTime(), (int)1);
            Validate.isTrue((boolean)DateUtils.isSameDay((Date)applyEndDate.getTime(), (Date)nextWeekEnd), (String)"\u7533\u8bf7\u4e0b\u5468\u6392\u73ed\u65f6,\u7533\u8bf7\u7ed3\u675f\u65f6\u95f4\u53ea\u80fd\u662f\u4e0b\u5468\u672b", (Object[])new Object[0]);
            AttendanceShiftApplication application = this.attendanceShiftApplicationRepository.findByUserAccountAndApplyPeriod(userAccount, this.findApplyPeriodByDate(nextWeekStart.getTime()));
            Validate.isTrue((boolean)Objects.isNull((Object)application), (String)"\u4e0b\u5468\u5df2\u7ecf\u7533\u8bf7\u8fc7", (Object[])new Object[0]);
        } else {
            throw new IllegalArgumentException("\u53ea\u80fd\u7533\u8bf7\u672c\u5468\u6216\u8005\u4e0b\u5468\u7684\u6392\u73ed");
        }
        shiftPlans.stream().forEach(o -> {
            Date cfr_ignored_0 = (Date)Validate.notNull((Object)o.getSchedulingDate(), (String)"\u6392\u73ed\u8be6\u60c5\u6392\u73ed\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
        Set set = shiftPlans.stream().filter(o -> applyStartDate.getTime().compareTo(o.getSchedulingDate()) <= 0 && applyEndDate.getTime().compareTo(o.getSchedulingDate()) >= 0).map(o -> DateUtils.truncate((Date)o.getSchedulingDate(), (int)5)).collect(Collectors.toSet());
        Validate.isTrue((set.size() == shiftPlans.size() ? 1 : 0) != 0, (String)"\u6392\u73ed\u65e5\u671f\u5fc5\u987b\u5728\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e4b\u95f4\u4e14\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
    }

    private void updateBusinessValidate(AttendanceShiftApplicationDto attendanceShiftApplicationDto) {
        List shiftPlans = attendanceShiftApplicationDto.getShiftPlans();
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)shiftPlans) && shiftPlans.size() == 7 ? 1 : 0) != 0, (String)"\u6392\u73ed\u7533\u8bf7\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u6bcf\u6b21\u53ea\u80fd\u7533\u8bf7\u4e03\u5929\u7684\u6392\u73ed", (Object[])new Object[0]);
        String id = attendanceShiftApplicationDto.getId();
        AttendanceShiftApplication shiftApplication = this.findById(id);
        Date applyStartDate = shiftApplication.getApplyStartDate();
        Date applyEndDate = shiftApplication.getApplyEndDate();
        Date applyDate = shiftApplication.getApplyDate();
        shiftPlans.stream().forEach(o -> {
            Date cfr_ignored_0 = (Date)Validate.notNull((Object)o.getSchedulingDate(), (String)"\u6392\u73ed\u8be6\u60c5\u6392\u73ed\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        });
        Set set = shiftPlans.stream().filter(o -> applyStartDate.compareTo(o.getSchedulingDate()) <= 0 && applyEndDate.compareTo(o.getSchedulingDate()) >= 0).map(o -> DateUtils.truncate((Date)o.getSchedulingDate(), (int)5)).collect(Collectors.toSet());
        Validate.isTrue((set.size() == shiftPlans.size() ? 1 : 0) != 0, (String)"\u6392\u73ed\u65e5\u671f\u5fc5\u987b\u5728\u5f00\u59cb\u65f6\u95f4\u548c\u7ed3\u675f\u65f6\u95f4\u4e4b\u95f4\u4e14\u4e0d\u80fd\u91cd\u590d", (Object[])new Object[0]);
    }

    @Override
    public String findApplyPeriodByDate(Date date) {
        Validate.notNull((Object)date, (String)"\u7533\u8bf7\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String format = "%04d%02d";
        Calendar calendar = DateUtils.toCalendar((Date)date);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(7);
        calendar.set(7, 2);
        String applyPeriod = String.format(format, calendar.get(1), calendar.get(3));
        return applyPeriod;
    }

    @Override
    public AttendanceShiftApplication findByUserAccountAndApplyPeriod(String userAccount, Date applyPeriodDate) {
        if (StringUtils.isBlank((CharSequence)userAccount) || Objects.isNull(applyPeriodDate)) {
            return null;
        }
        String applyPeriod = this.findApplyPeriodByDate(applyPeriodDate);
        return this.attendanceShiftApplicationRepository.findByUserAccountAndApplyPeriod(userAccount, applyPeriod);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAuditStatusByIdBatch(AttendanceShiftApplicationApproveDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba1\u6838\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List ids = dto.getIds();
        String auditStatus = dto.getAuditStatus();
        Date now = new Date();
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Validate.notBlank((CharSequence)loginAccountName, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u8d26\u6237\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u8bf7\u9009\u4e2d\u8981\u5ba1\u6838\u7684\u5bf9\u8c61", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)auditStatus), (String)"\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((ShiftApplicationAuditStatusEnum.REJECTED.getDictCode().equals(auditStatus) || ShiftApplicationAuditStatusEnum.PASS.getDictCode().equals(auditStatus) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u9009\u62e9\u5ba1\u6838\u901a\u8fc7\u548c\u9a73\u56de", (Object[])new Object[0]);
        List<AttendanceShiftApplication> applications = this.attendanceShiftApplicationRepository.findByIds(ids);
        Validate.isTrue((ids.size() == applications.size() ? 1 : 0) != 0, (String)"\u6279\u91cf\u5ba1\u6279\u65f6,\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        for (AttendanceShiftApplication application : applications) {
            Validate.isTrue((boolean)ShiftApplicationAuditStatusEnum.NO_AUDIT.getDictCode().equals(application.getAuditStatus()), (String)String.format("\u7f16\u7801\u4e3a %s\u7684\u7533\u8bf7\u5df2\u7ecf\u5ba1\u6838,\u4e0d\u80fd\u91cd\u590d\u5ba1\u6838", application.getApplyCode()), (Object[])new Object[0]);
            application.setModifyTime(now);
            application.setModifyAccount(loginAccountName);
            application.setAuditStatus(auditStatus);
            application.setAuditDate(now);
            if (!ShiftApplicationAuditStatusEnum.REJECTED.getDictCode().equals(auditStatus)) continue;
            application.setRejectedReason(dto.getRejectedReason());
        }
        this.attendanceShiftApplicationRepository.saveOrUpdateBatch(applications);
    }

    @Override
    public AttendanceShiftApplication findByApplyCode(String applyCode) {
        if (StringUtils.isBlank((CharSequence)applyCode)) {
            return null;
        }
        return this.attendanceShiftApplicationRepository.findByApplyCode(applyCode);
    }
}

