/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftApplicationVoRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftApplicationService;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.service.AttendanceShiftApplicationVoService;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftPlanVo;
import java.util.Arrays;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="attendanceShiftApplicationVoService")
public class AttendanceShiftApplicationVoServiceImpl
implements AttendanceShiftApplicationVoService {
    @Autowired
    private AttendanceShiftApplicationVoRepository attendanceShiftApplicationVoRepository;
    @Autowired
    private AttendanceShiftApplicationService attendanceShiftApplicationService;
    @Autowired
    private LoginUserService loginUserService;

    public Page<AttendanceShiftApplicationVo> findDetailsByConditions(Pageable pageable, ShiftApplicationConditionDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ShiftApplicationConditionDto();
        }
        return this.attendanceShiftApplicationVoRepository.findDetailsByConditions(pageable, dto);
    }

    public AttendanceShiftApplicationVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.attendanceShiftApplicationVoRepository.findDetailsById(id);
    }

    public AttendanceShiftApplicationVo findDetailsByApplyCode(String applyCode) {
        if (StringUtils.isBlank((CharSequence)applyCode)) {
            return null;
        }
        return this.attendanceShiftApplicationVoRepository.findDetailsByApplyCode(applyCode);
    }

    public AttendanceShiftApplicationVo findByCurrentUserAndApplyPeriodDate(Date applyPeriodDate) {
        if (Objects.isNull(applyPeriodDate)) {
            return null;
        }
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7684\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String account = loginUser.getConsumerCode();
        String applyPeriod = this.attendanceShiftApplicationService.findApplyPeriodByDate(applyPeriodDate);
        return this.attendanceShiftApplicationVoRepository.findByUserAccountAndApplyPeriod(account, applyPeriod);
    }

    public AttendanceShiftApplicationVo findByCurrentUserAndDate(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        AttendanceShiftApplicationVo attendanceShiftApplicationVo = this.findByCurrentUserAndApplyPeriodDate(date);
        if (attendanceShiftApplicationVo == null) {
            return null;
        }
        AttendanceShiftPlanVo attendanceShiftPlanVo = attendanceShiftApplicationVo.getShiftPlans().stream().filter(o -> DateUtils.isSameDay((Date)date, (Date)o.getSchedulingDate())).findFirst().orElse(null);
        if (attendanceShiftPlanVo == null) {
            return null;
        }
        attendanceShiftApplicationVo.setShiftPlans(Arrays.asList(attendanceShiftPlanVo));
        return attendanceShiftApplicationVo;
    }
}

