/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftApplication;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftPlan;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftPlanRepository;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftApplicationService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftPlanService;
import com.biz.crm.cps.business.attendance.sdk.common.enums.CompensatoryLeaveTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftApplicationAuditStatusEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftPlanTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftPlanDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="AttendanceShiftPlanService")
public class AttendanceShiftPlanServiceImpl
implements AttendanceShiftPlanService {
    @Autowired
    private AttendanceShiftPlanRepository attendanceShiftPlanRepository;
    @Autowired
    private AttendanceShiftRepository attendanceShiftRepository;
    @Autowired
    private AttendanceShiftApplicationService attendanceShiftApplicationService;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public Page<AttendanceShiftPlan> findByConditions(Pageable pageable, AttendanceShiftPlan attendanceShiftPlan) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull((Object)attendanceShiftPlan)) {
            attendanceShiftPlan = new AttendanceShiftPlan();
        }
        return this.attendanceShiftPlanRepository.findByConditions(pageable, attendanceShiftPlan);
    }

    @Override
    public AttendanceShiftPlan findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (AttendanceShiftPlan)((Object)this.attendanceShiftPlanRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public AttendanceShiftPlan create(AttendanceShiftPlan attendanceShiftPlan) {
        this.createValidate(attendanceShiftPlan);
        this.attendanceShiftPlanRepository.saveOrUpdate((Object)attendanceShiftPlan);
        return attendanceShiftPlan;
    }

    @Override
    @Transactional
    public AttendanceShiftPlan update(AttendanceShiftPlan attendanceShiftPlan) {
        this.updateValidate(attendanceShiftPlan);
        this.attendanceShiftPlanRepository.saveOrUpdate((Object)attendanceShiftPlan);
        return attendanceShiftPlan;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.attendanceShiftPlanRepository.removeByIds(idList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createBatch(String applyCode, List<AttendanceShiftPlanDto> attendanceShiftPlans) {
        this.createValidate(attendanceShiftPlans);
        this.deleteByApplyCode(applyCode);
        Date now = new Date();
        String loginAccountName = this.loginUserService.getLoginAccountName();
        String tenantCode = TenantUtils.getTenantCode();
        ArrayList current = Lists.newArrayList();
        for (AttendanceShiftPlanDto attendanceShiftPlanDto : attendanceShiftPlans) {
            AttendanceShiftPlan attendanceShiftPlan = new AttendanceShiftPlan();
            attendanceShiftPlan.setApplyCode(applyCode);
            attendanceShiftPlan.setTenantCode(tenantCode);
            attendanceShiftPlan.setCreateAccount(loginAccountName);
            attendanceShiftPlan.setCreateTime(now);
            attendanceShiftPlan.setModifyAccount(loginAccountName);
            attendanceShiftPlan.setModifyTime(now);
            BeanUtils.copyProperties((Object)attendanceShiftPlanDto, (Object)((Object)attendanceShiftPlan));
            Integer dayOfWeek = this.getDayOfWeek(attendanceShiftPlanDto.getSchedulingDate());
            attendanceShiftPlan.setWeek(dayOfWeek);
            if (!attendanceShiftPlanDto.getEffectiveDate().booleanValue()) {
                attendanceShiftPlan.setCompensatoryLeaveType(CompensatoryLeaveTypeEnum.NOT_COMPENSATORY_LEAVE.getDictCode());
                attendanceShiftPlan.setShiftPlanType(ShiftPlanTypeEnum.EXPIRY_DATE.getDictCode());
                attendanceShiftPlan.setHoliday(false);
                current.add(attendanceShiftPlan);
                continue;
            }
            Calendar calendar = DateUtils.toCalendar((Date)attendanceShiftPlanDto.getSchedulingDate());
            calendar.setFirstDayOfWeek(2);
            int week = calendar.get(7);
            if ((attendanceShiftPlanDto.getHoliday().booleanValue() || week == 7 || week == 1) && StringUtils.isBlank((CharSequence)attendanceShiftPlanDto.getShiftCode())) {
                attendanceShiftPlan.setShiftPlanType(ShiftPlanTypeEnum.REST_DAY.getDictCode());
                attendanceShiftPlan.setCompensatoryLeaveType(CompensatoryLeaveTypeEnum.NOT_COMPENSATORY_LEAVE.getDictCode());
                attendanceShiftPlan.setTerminalCode(null);
                attendanceShiftPlan.setTerminalName(null);
                current.add(attendanceShiftPlan);
                continue;
            }
            String shiftCode = attendanceShiftPlanDto.getShiftCode();
            AttendanceShift attendanceShift = this.attendanceShiftRepository.findByShiftCode(shiftCode);
            Validate.notNull((Object)((Object)attendanceShift), (String)"\u4e0d\u5b58\u5728\u7684\u73ed\u6b21", (Object[])new Object[0]);
            if (ShiftTypeEnum.DAY_COMPENSATORY_LEAVE.getDictCode().equals(attendanceShift.getShiftType())) {
                attendanceShiftPlanDto.setCompensatoryLeaveType(CompensatoryLeaveTypeEnum.NOT_COMPENSATORY_LEAVE.getDictCode());
            }
            attendanceShiftPlan.setShiftCode(shiftCode);
            attendanceShiftPlan.setShiftColor(attendanceShift.getShiftColor());
            attendanceShiftPlan.setShiftName(attendanceShift.getShiftName());
            attendanceShiftPlan.setShiftType(attendanceShift.getShiftType());
            attendanceShiftPlan.setShiftDescribe(attendanceShift.getShiftDescribe());
            attendanceShiftPlan.setAcrossDay(attendanceShift.getAcrossDay());
            attendanceShiftPlan.setShiftPlanType(attendanceShift.getShiftType());
            attendanceShiftPlan.setCompensatoryLeaveLength(BigDecimal.ZERO);
            attendanceShiftPlan.setNormalWorkHours(BigDecimal.ZERO);
            Date workStartDate = attendanceShiftPlanDto.getSchedulingDate();
            long startMinutes = DateUtils.getFragmentInMinutes((Date)attendanceShift.getWorkStartTime(), (int)5);
            workStartDate = DateUtils.addMinutes((Date)workStartDate, (int)((int)startMinutes));
            attendanceShiftPlan.setWorkStartDate(workStartDate);
            if (attendanceShift.getLatestSignInTime() != null) {
                Date latestSignInDate = attendanceShiftPlanDto.getSchedulingDate();
                long latestSignInMinutes = DateUtils.getFragmentInMinutes((Date)attendanceShift.getLatestSignInTime(), (int)5);
                latestSignInDate = DateUtils.addMinutes((Date)latestSignInDate, (int)((int)latestSignInMinutes));
                attendanceShiftPlan.setLatestSignInDate(latestSignInDate);
            }
            Date workEndDate = attendanceShiftPlanDto.getSchedulingDate();
            long endMinutes = DateUtils.getFragmentInMinutes((Date)attendanceShift.getWorkEndTime(), (int)5);
            workEndDate = DateUtils.addMinutes((Date)workEndDate, (int)((int)endMinutes));
            if (attendanceShift.getAcrossDay().booleanValue()) {
                workEndDate = DateUtils.addDays((Date)workEndDate, (int)1);
            }
            attendanceShiftPlan.setWorkEndDate(workEndDate);
            if (attendanceShift.getEarliestSignBackTime() != null) {
                Date earliestSignBackDate = attendanceShiftPlanDto.getSchedulingDate();
                if (attendanceShift.getAcrossDay().booleanValue()) {
                    earliestSignBackDate = DateUtils.addDays((Date)earliestSignBackDate, (int)1);
                }
                long earliestSignBackMinutes = DateUtils.getFragmentInMinutes((Date)attendanceShift.getEarliestSignBackTime(), (int)5);
                earliestSignBackDate = DateUtils.addMinutes((Date)earliestSignBackDate, (int)((int)earliestSignBackMinutes));
                attendanceShiftPlan.setEarliestSignBackDate(earliestSignBackDate);
            }
            if (!CompensatoryLeaveTypeEnum.NOT_COMPENSATORY_LEAVE.getDictCode().equals(attendanceShiftPlanDto.getCompensatoryLeaveType())) {
                Date compensatoryLeaveStartDate = attendanceShiftPlanDto.getCompensatoryLeaveStartDate();
                Date compensatoryLeaveEndDate = attendanceShiftPlanDto.getCompensatoryLeaveEndDate();
                Validate.isTrue((compensatoryLeaveStartDate.compareTo(workStartDate) >= 0 ? 1 : 0) != 0, (String)String.format("%tF \u7684\u8c03\u4f11\u65f6\u95f4\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4e0a\u73ed\u65f6\u95f4", attendanceShiftPlan.getSchedulingDate()), (Object[])new Object[0]);
                Validate.isTrue((compensatoryLeaveEndDate.compareTo(workEndDate) <= 0 ? 1 : 0) != 0, (String)String.format("%tF \u7684\u8c03\u4f11\u7ed3\u675f\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8e\u4e0b\u73ed\u65f6\u95f4", attendanceShiftPlan.getSchedulingDate()), (Object[])new Object[0]);
                Validate.isTrue((boolean)compensatoryLeaveStartDate.before(compensatoryLeaveEndDate), (String)String.format("%tF \u7684\u8c03\u4f11\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u524d", attendanceShiftPlan.getSchedulingDate()), (Object[])new Object[0]);
                attendanceShiftPlan.setCompensatoryLeaveStartDate(compensatoryLeaveStartDate);
                attendanceShiftPlan.setCompensatoryLeaveEndDate(compensatoryLeaveEndDate);
                BigDecimal compensatoryLeaveLength = this.calculateWorkHours(compensatoryLeaveStartDate, compensatoryLeaveEndDate);
                attendanceShiftPlan.setCompensatoryLeaveLength(compensatoryLeaveLength);
            }
            BigDecimal shiftWorkLength = this.calculateWorkHours(workStartDate, workEndDate);
            if (ShiftPlanTypeEnum.DAY_COMPENSATORY_LEAVE.getDictCode().equals(attendanceShift.getShiftType())) {
                attendanceShiftPlan.setCompensatoryLeaveLength(shiftWorkLength);
                current.add(attendanceShiftPlan);
                continue;
            }
            attendanceShiftPlan.setNormalWorkHours(shiftWorkLength.subtract(attendanceShiftPlan.getCompensatoryLeaveLength()));
            current.add(attendanceShiftPlan);
        }
        this.businessValidate(current);
        this.attendanceShiftPlanRepository.saveOrUpdateBatch(current);
    }

    @Override
    @Transactional
    public void deleteByApplyCode(String applyCode) {
        if (StringUtils.isBlank((CharSequence)applyCode)) {
            return;
        }
        this.attendanceShiftPlanRepository.deleteByApplyCode(applyCode);
    }

    @Override
    public AttendanceShiftPlan findByCurrentUserAndDate(Date date) {
        if (Objects.isNull(date)) {
            return null;
        }
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
        String account = loginUser.getConsumerCode();
        AttendanceShiftApplication application = this.attendanceShiftApplicationService.findByUserAccountAndApplyPeriod(account, date);
        if (Objects.isNull((Object)application) || !ShiftApplicationAuditStatusEnum.PASS.getDictCode().equals(application.getAuditStatus())) {
            return null;
        }
        return this.attendanceShiftPlanRepository.findByApplyCodeAndSchedulingDate(application.getApplyCode(), DateUtils.truncate((Date)date, (int)5));
    }

    @Override
    public AttendanceShiftPlan findByApplyCodeAndSchedulingDate(String applyCode, Date schedulingDate) {
        if (StringUtils.isBlank((CharSequence)applyCode) || Objects.isNull(schedulingDate)) {
            return null;
        }
        return this.attendanceShiftPlanRepository.findByApplyCodeAndSchedulingDate(applyCode, DateUtils.truncate((Date)schedulingDate, (int)5));
    }

    @Override
    public AttendanceShiftPlan findByUserAccountAndSchedulingDate(String userAccount, Date schedulingDate) {
        if (StringUtils.isBlank((CharSequence)userAccount) || Objects.isNull(schedulingDate)) {
            return null;
        }
        return this.attendanceShiftPlanRepository.findByUserAccountAndSchedulingDate(userAccount, DateUtils.truncate((Date)schedulingDate, (int)5));
    }

    @Override
    public List<AttendanceShiftPlan> findBySchedulingDateAndAuditStatus(Date schedulingDate, String auditStatus) {
        if (StringUtils.isBlank((CharSequence)auditStatus) || Objects.isNull(schedulingDate)) {
            return Lists.newArrayList();
        }
        return this.attendanceShiftPlanRepository.findBySchedulingDateAndAuditStatus(auditStatus, DateUtils.truncate((Date)schedulingDate, (int)5));
    }

    private void createValidate(List<AttendanceShiftPlanDto> attendanceShiftPlanDtos) {
        Validate.isTrue((!CollectionUtils.isEmpty(attendanceShiftPlanDtos) ? 1 : 0) != 0, (String)"\u6392\u73ed\u7533\u8bf7\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (AttendanceShiftPlanDto attendanceShiftPlanDto : attendanceShiftPlanDtos) {
            Validate.notNull((Object)attendanceShiftPlanDto.getSchedulingDate(), (String)"\u6392\u73ed\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notNull((Object)attendanceShiftPlanDto.getEffectiveDate(), (String)"\u662f\u5426\u4e3a\u6709\u6548\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!attendanceShiftPlanDto.getEffectiveDate().booleanValue()) continue;
            attendanceShiftPlanDto.setHoliday(Boolean.valueOf(false));
            Validate.notNull((Object)attendanceShiftPlanDto.getHoliday(), (String)"\u6392\u73ed\u8be6\u60c5\uff0c\u662f\u5426\u662f\u8282\u5047\u65e5\u6216\u5468\u672b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Calendar calendar = DateUtils.toCalendar((Date)attendanceShiftPlanDto.getSchedulingDate());
            calendar.setFirstDayOfWeek(2);
            int dayOfWeek = calendar.get(7);
            if ((attendanceShiftPlanDto.getHoliday().booleanValue() || dayOfWeek == 7 || dayOfWeek == 1) && StringUtils.isBlank((CharSequence)attendanceShiftPlanDto.getShiftCode())) continue;
            Validate.notBlank((CharSequence)attendanceShiftPlanDto.getShiftCode(), (String)"\u73ed\u6b21\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            AttendanceShift shift = this.attendanceShiftRepository.findByShiftCode(attendanceShiftPlanDto.getShiftCode());
            Validate.notNull((Object)((Object)shift), (String)"\u672a\u77e5\u7684\u73ed\u6b21\u5bf9\u8c61", (Object[])new Object[0]);
            if (ShiftTypeEnum.DAY_COMPENSATORY_LEAVE.getDictCode().equals(shift.getShiftType())) continue;
            Validate.notBlank((CharSequence)attendanceShiftPlanDto.getTerminalCode(), (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)attendanceShiftPlanDto.getTerminalName(), (String)"\u7ec8\u7aef\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)attendanceShiftPlanDto.getTerminalType(), (String)"\u7ec8\u7aef\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)attendanceShiftPlanDto.getCompensatoryLeaveType(), (String)"\u6392\u73ed\u8be6\u60c5\uff0c\u8c03\u4f11\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!CompensatoryLeaveTypeEnum.NOT_COMPENSATORY_LEAVE.getDictCode().equals(attendanceShiftPlanDto.getCompensatoryLeaveType())) {
                Validate.notNull((Object)attendanceShiftPlanDto.getCompensatoryLeaveStartDate(), (String)"\u9009\u62e9\u8c03\u4f11\u540e\uff0c\u8c03\u4f11\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Validate.notNull((Object)attendanceShiftPlanDto.getCompensatoryLeaveEndDate(), (String)"\u9009\u62e9\u8c03\u4f11\u540e\uff0c\u8c03\u4f11\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (!CompensatoryLeaveTypeEnum.ACROSS_DAY_COMPENSATORY_LEAVE.getDictCode().equals(attendanceShiftPlanDto.getCompensatoryLeaveType())) continue;
                Validate.isTrue((boolean)shift.getAcrossDay(), (String)"\u53ea\u6709\u8de8\u5929\u73ed\u6b21\u624d\u80fd\u9009\u62e9\u8de8\u5929\u8c03\u4f11", (Object[])new Object[0]);
                continue;
            }
            attendanceShiftPlanDto.setCompensatoryLeaveStartDate(null);
            attendanceShiftPlanDto.setCompensatoryLeaveEndDate(null);
        }
    }

    private void businessValidate(List<AttendanceShiftPlan> attendanceShiftPlans) {
        Validate.isTrue((!CollectionUtils.isEmpty(attendanceShiftPlans) ? 1 : 0) != 0, (String)"\u6392\u73ed\u8ba1\u5212\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List plans = attendanceShiftPlans.stream().sorted(Comparator.comparing(AttendanceShiftPlan::getSchedulingDate)).collect(Collectors.toList());
        for (int i = 0; i < plans.size() - 1; ++i) {
            AttendanceShiftPlan plan = (AttendanceShiftPlan)((Object)plans.get(i));
            AttendanceShiftPlan nextDayPlan = (AttendanceShiftPlan)((Object)plans.get(i + 1));
            if (!Objects.nonNull(plan.getWorkEndDate()) || !Objects.nonNull(nextDayPlan.getWorkStartDate())) continue;
            Validate.isTrue((boolean)plan.getWorkEndDate().before(nextDayPlan.getWorkStartDate()), (String)String.format("%tF\u4e0e%tF\u7684\u5de5\u4f5c\u65f6\u95f4\u6709\u51b2\u7a81!\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5", plan.getSchedulingDate(), nextDayPlan.getSchedulingDate()), (Object[])new Object[0]);
        }
    }

    private void createValidate(AttendanceShiftPlan attendanceShiftPlan) {
        Validate.notNull((Object)((Object)attendanceShiftPlan), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        attendanceShiftPlan.setId(null);
        Validate.notBlank((CharSequence)attendanceShiftPlan.getShiftCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShiftPlan.getShiftColor(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u6807\u8bc6\u989c\u8272 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftPlan.getShiftDescribe(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u63cf\u8ff0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftPlan.getShiftName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShiftPlan.getShiftType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AttendanceShiftPlan attendanceShiftPlan) {
        Validate.notNull((Object)((Object)attendanceShiftPlan), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftPlan.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftPlan.getShiftCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShiftPlan.getShiftColor(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u6807\u8bc6\u989c\u8272 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftPlan.getShiftDescribe(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u63cf\u8ff0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShiftPlan.getShiftName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShiftPlan.getShiftType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private BigDecimal calculateWorkHours(Date start, Date end) {
        BigDecimal s = BigDecimal.valueOf(start.getTime());
        BigDecimal e = BigDecimal.valueOf(end.getTime());
        BigDecimal hourMinutes = BigDecimal.valueOf(3600000L);
        BigDecimal totalMinutes = e.subtract(s);
        return totalMinutes.divide(hourMinutes, 2, 4);
    }

    private Integer getDayOfWeek(Date date) {
        Calendar calendar = DateUtils.toCalendar((Date)date);
        boolean isFirstSunday = calendar.getFirstDayOfWeek() == 1;
        int weekDay = calendar.get(7);
        if (isFirstSunday && --weekDay == 0) {
            weekDay = 7;
        }
        return weekDay;
    }
}

