/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.attendance.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShift;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftOrganizationRelationship;
import com.biz.crm.cps.business.attendance.local.entity.AttendanceShiftUserRelationship;
import com.biz.crm.cps.business.attendance.local.repository.AttendanceShiftRepository;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftOrganizationRelationshipService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftService;
import com.biz.crm.cps.business.attendance.local.service.AttendanceShiftUserRelationshipService;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftTypeEnum;
import com.biz.crm.cps.business.attendance.sdk.common.enums.ShoppingGuideSelectMethodEnum;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftOrganizationRelationshipDto;
import com.biz.crm.cps.business.attendance.sdk.dto.AttendanceShiftUserRelationshipDto;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.user.sdk.service.UserFeignVoService;
import com.biz.crm.mdm.business.user.sdk.vo.UserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="AttendanceShiftService")
public class AttendanceShiftServiceImpl
implements AttendanceShiftService {
    @Autowired
    private AttendanceShiftRepository attendanceShiftRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private AttendanceShiftUserRelationshipService attendanceShiftUserRelationshipService;
    @Autowired
    private AttendanceShiftOrganizationRelationshipService attendanceShiftOrganizationRelationshipService;
    @Autowired
    private UserFeignVoService userFeignVoService;

    @Override
    public Page<AttendanceShift> findByConditions(Pageable pageable, ShiftConditionDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ShiftConditionDto();
        }
        return this.attendanceShiftRepository.findByConditions(pageable, dto);
    }

    @Override
    public AttendanceShift findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (AttendanceShift)((Object)this.attendanceShiftRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public AttendanceShift create(AttendanceShiftDto attendanceShiftDto) {
        Validate.notNull((Object)attendanceShiftDto, (String)"\u521b\u5efa\u73ed\u6b21\u65f6\uff0c\u73ed\u6b21\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AttendanceShift attendanceShift = (AttendanceShift)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)attendanceShiftDto, AttendanceShift.class, HashSet.class, ArrayList.class, new String[0]));
        AttendanceShift current = this.createForm(attendanceShift);
        attendanceShiftDto.setId(null);
        this.businessValidate(attendanceShiftDto);
        this.attendanceShiftRepository.save((Object)current);
        attendanceShiftDto.setShiftCode(current.getShiftCode());
        this.saveShiftRelationship(attendanceShiftDto);
        return current;
    }

    @Override
    public AttendanceShift createForm(AttendanceShift attendanceShift) {
        this.createValidate(attendanceShift);
        Date now = new Date();
        attendanceShift.setCreateTime(now);
        attendanceShift.setModifyTime(now);
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Validate.notBlank((CharSequence)loginAccountName, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u8d26\u53f7", (Object[])new Object[0]);
        attendanceShift.setCreateAccount(loginAccountName);
        attendanceShift.setModifyAccount(loginAccountName);
        attendanceShift.setShiftName(this.buildShiftName(attendanceShift));
        attendanceShift.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        attendanceShift.setTenantCode(TenantUtils.getTenantCode());
        String shiftCode = (String)this.generateCodeService.generateCode("BCBM", 1).get(0);
        Validate.notBlank((CharSequence)shiftCode, (String)"\u751f\u6210\u73ed\u6b21\u7f16\u7801\u5931\u8d25\uff01", (Object[])new Object[0]);
        AttendanceShift shift = this.attendanceShiftRepository.findByShiftCode(shiftCode);
        Validate.isTrue((boolean)Objects.isNull((Object)shift), (String)"\u73ed\u6b21\u7f16\u7801\u91cd\u590d", (Object[])new Object[0]);
        attendanceShift.setShiftCode(shiftCode);
        return attendanceShift;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveShiftRelationship(AttendanceShiftDto attendanceShiftDto) {
        String shiftCode = attendanceShiftDto.getShiftCode();
        Validate.notBlank((CharSequence)shiftCode, (String)"\u73ed\u6b21\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.attendanceShiftOrganizationRelationshipService.deleteByShiftCode(shiftCode);
        this.attendanceShiftUserRelationshipService.deleteByShiftCode(shiftCode);
        if (ShoppingGuideSelectMethodEnum.PART.getDictCode().equals(attendanceShiftDto.getShoppingGuideSelectMethod())) {
            Set organizationRelationshipDtos = attendanceShiftDto.getShiftOrganizationRelationships();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)organizationRelationshipDtos) ? 1 : 0) != 0, (String)"\u73ed\u6b21\u5173\u8054\u7684\u7ec4\u7ec7\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Set shiftOrganizationRelationshipSet = (Set)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)organizationRelationshipDtos, AttendanceShiftOrganizationRelationshipDto.class, AttendanceShiftOrganizationRelationship.class, HashSet.class, ArrayList.class, new String[0]);
            shiftOrganizationRelationshipSet.forEach(o -> o.setShiftCode(shiftCode));
            this.attendanceShiftOrganizationRelationshipService.createBatch(shiftCode, shiftOrganizationRelationshipSet);
        } else if (ShoppingGuideSelectMethodEnum.SPECIFIED.getDictCode().equals(attendanceShiftDto.getShoppingGuideSelectMethod())) {
            Set shiftUserRelationshipDtos = attendanceShiftDto.getShiftUserRelationships();
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)shiftUserRelationshipDtos) ? 1 : 0) != 0, (String)"\u73ed\u6b21\u5173\u8054\u7684\u5bfc\u8d2d\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Set shiftUserRelationshipSet = (Set)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)shiftUserRelationshipDtos, AttendanceShiftUserRelationshipDto.class, AttendanceShiftUserRelationship.class, HashSet.class, ArrayList.class, new String[0]);
            shiftUserRelationshipSet.forEach(u -> u.setShiftCode(shiftCode));
            this.attendanceShiftUserRelationshipService.createBatch(shiftCode, shiftUserRelationshipSet);
        } else {
            if (ShoppingGuideSelectMethodEnum.ALL.getDictCode().equals(attendanceShiftDto.getShoppingGuideSelectMethod())) {
                return;
            }
            throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
        }
    }

    @Override
    @Transactional
    public AttendanceShift update(AttendanceShiftDto attendanceShiftDto) {
        AttendanceShift attendanceShift = (AttendanceShift)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)attendanceShiftDto, AttendanceShift.class, HashSet.class, ArrayList.class, new String[0]));
        AttendanceShift current = this.updateFrom(attendanceShift);
        this.attendanceShiftRepository.saveOrUpdate((Object)current);
        attendanceShiftDto.setId(current.getId());
        this.businessValidate(attendanceShiftDto);
        attendanceShiftDto.setShiftCode(current.getShiftCode());
        this.saveShiftRelationship(attendanceShiftDto);
        return current;
    }

    @Override
    public AttendanceShift updateFrom(AttendanceShift attendanceShift) {
        this.updateValidate(attendanceShift);
        String shiftId = attendanceShift.getId();
        String shiftCode = attendanceShift.getShiftCode();
        AttendanceShift current = null;
        if (StringUtils.isNotBlank((CharSequence)shiftId)) {
            current = this.attendanceShiftRepository.findById(shiftId);
        } else if (current == null && StringUtils.isNotBlank((CharSequence)shiftCode)) {
            current = this.attendanceShiftRepository.findByShiftCode(shiftCode);
        }
        Validate.notNull((Object)((Object)current), (String)"\u6ca1\u6709\u627e\u5230\u539f\u59cb\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)attendanceShift), (Object)((Object)current), (String[])new String[]{"id", "tenantCode", "delFlag", "createAccount", "createTime", "shiftCode", "remark"});
        Date now = new Date();
        current.setModifyTime(now);
        String loginAccountName = this.loginUserService.getLoginAccountName();
        Validate.notBlank((CharSequence)loginAccountName, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237\u8d26\u53f7", (Object[])new Object[0]);
        current.setModifyAccount(loginAccountName);
        current.setShiftName(this.buildShiftName(current));
        return current;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.attendanceShiftRepository.removeByIds(idList);
    }

    @Override
    public List<AttendanceShift> findByCurrentUser() {
        LoginUserDetailsForCPS loginUser = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUser, (String)"\u83b7\u53d6\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\u5931\u8d25", (Object[])new Object[0]);
        String account = loginUser.getConsumerCode();
        List<AttendanceShift> shiftList = this.findByUserAccount(account);
        Validate.isTrue((!CollectionUtils.isEmpty(shiftList) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7528\u6237\u6682\u65e0\u53ef\u7528\u73ed\u6b21", (Object[])new Object[0]);
        return shiftList;
    }

    @Override
    public List<AttendanceShift> findByUserAccount(String userAccount) {
        if (StringUtils.isBlank((CharSequence)userAccount)) {
            return Lists.newArrayList();
        }
        ArrayList result = Lists.newArrayList();
        List<AttendanceShift> attendanceShifts = this.attendanceShiftRepository.findByShoppingGuideSelectMethodAndEnable(ShoppingGuideSelectMethodEnum.ALL.getDictCode());
        result.addAll(attendanceShifts);
        List<AttendanceShift> specifiedShifts = this.attendanceShiftRepository.findByShoppingGuideSelectMethodAndEnable(ShoppingGuideSelectMethodEnum.SPECIFIED.getDictCode());
        for (AttendanceShift attendanceShift : specifiedShifts) {
            List<AttendanceShiftUserRelationship> userRels = this.attendanceShiftUserRelationshipService.findByShiftCode(attendanceShift.getShiftCode());
            Set userSet = userRels.stream().map(AttendanceShiftUserRelationship::getUserAccount).collect(Collectors.toSet());
            if (!userSet.contains(userAccount)) continue;
            result.add(attendanceShift);
        }
        List<AttendanceShift> partShifts = this.attendanceShiftRepository.findByShoppingGuideSelectMethodAndEnable(ShoppingGuideSelectMethodEnum.PART.getDictCode());
        if (!CollectionUtils.isEmpty(partShifts)) {
            List userVos = this.userFeignVoService.findByUserNames(Arrays.asList(userAccount));
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)userVos) ? 1 : 0) != 0, (String)"\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
            UserVo userVo = (UserVo)userVos.get(0);
            Validate.notNull((Object)userVo, (String)"\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u7684\u7528\u6237\u4fe1\u606f", (Object[])new Object[0]);
            HashSet orgCodes = Sets.newHashSet();
            if (!CollectionUtils.isEmpty((Collection)userVo.getPositionList())) {
                userVo.getPositionList().stream().forEach(p -> orgCodes.addAll(p.getOrgCodes()));
            }
            for (AttendanceShift attendanceShift : partShifts) {
                List<AttendanceShiftOrganizationRelationship> orgRels = this.attendanceShiftOrganizationRelationshipService.findByShiftCode(attendanceShift.getShiftCode());
                Set orgSet = orgRels.stream().map(AttendanceShiftOrganizationRelationship::getOrgCode).collect(Collectors.toSet());
                if (Sets.intersection((Set)orgCodes, orgSet).isEmpty()) continue;
                result.add(attendanceShift);
            }
        }
        return result;
    }

    private void createValidate(AttendanceShift attendanceShift) {
        Validate.notNull((Object)((Object)attendanceShift), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        attendanceShift.setId(null);
        Validate.notBlank((CharSequence)attendanceShift.getEnableStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u73ed\u6b21\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShiftColor(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u6807\u8bc6\u989c\u8272 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShiftName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShiftType(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShift.getAcrossDay(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u662f\u5426\u8de8\u5929\u73ed\u6b21\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShoppingGuideSelectMethod(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5bfc\u8d2d\u9009\u62e9\u65b9\u5f0f \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShift.getWorkEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5de5\u4f5c\u7ed3\u675f\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShift.getWorkStartTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(AttendanceShift attendanceShift) {
        Validate.notNull((Object)((Object)attendanceShift), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)attendanceShift.getId()) || StringUtils.isNotBlank((CharSequence)attendanceShift.getShiftCode()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0cid\u6216\u7f16\u7801\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShiftColor(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u6807\u8bc6\u989c\u8272 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getEnableStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u73ed\u6b21\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShiftName(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShiftType(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c \u73ed\u6b21\u7c7b\u578b \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShift.getAcrossDay(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c\u662f\u5426\u8de8\u5929\u73ed\u6b21\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)attendanceShift.getShoppingGuideSelectMethod(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c \u5bfc\u8d2d\u9009\u62e9\u65b9\u5f0f \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShift.getWorkEndTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c \u5de5\u4f5c\u7ed3\u675f\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)attendanceShift.getWorkStartTime(), (String)"\u4fee\u6539\u6570\u636e\u65f6\uff0c \u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void businessValidate(AttendanceShiftDto attendanceShiftDto) {
        Validate.isTrue((attendanceShiftDto.getAcrossDay() != false || attendanceShiftDto.getWorkStartTime().before(attendanceShiftDto.getWorkEndTime()) ? 1 : 0) != 0, (String)"\u975e\u8de8\u5929\u73ed\u6b21\u4e0b\uff0c\u5de5\u4f5c\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5de5\u4f5c\u7ed3\u675f\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((attendanceShiftDto.getLatestSignInTime() == null || attendanceShiftDto.getWorkStartTime().before(attendanceShiftDto.getLatestSignInTime()) ? 1 : 0) != 0, (String)"\u6700\u665a\u7b7e\u5230\u65f6\u95f4\u4e00\u5b9a\u5927\u4e8e\u4e0a\u73ed\u65f6\u95f4", (Object[])new Object[0]);
        Validate.isTrue((attendanceShiftDto.getEarliestSignBackTime() == null || attendanceShiftDto.getWorkEndTime().after(attendanceShiftDto.getEarliestSignBackTime()) ? 1 : 0) != 0, (String)"\u6700\u65e9\u7b7e\u9000\u65f6\u95f4\u4e00\u5b9a\u5c0f\u4e8e\u4e0b\u73ed\u65f6\u95f4", (Object[])new Object[0]);
        List<Object> attendanceShifts = Lists.newArrayList();
        attendanceShifts = StringUtils.isNotBlank((CharSequence)attendanceShiftDto.getId()) ? this.attendanceShiftRepository.findByShiftTypeAndEnableAndIdNot(attendanceShiftDto.getShiftType(), attendanceShiftDto.getId()) : this.attendanceShiftRepository.findByShiftTypeAndEnable(attendanceShiftDto.getShiftType());
        if (CollectionUtils.isEmpty((Collection)attendanceShifts) || EnableStatusEnum.DISABLE.getCode().equals(attendanceShiftDto.getEnableStatus())) {
            return;
        }
        String createSelectMethod = attendanceShiftDto.getShoppingGuideSelectMethod();
        Validate.isTrue((!ShoppingGuideSelectMethodEnum.ALL.getDictCode().equals(createSelectMethod) ? 1 : 0) != 0, (String)"\u8be5\u73ed\u6b21\u7c7b\u578b\u5df2\u7ecf\u521b\u5efa\uff0c\u4e0d\u80fd\u9009\u62e9\u5168\u90e8\u5bfc\u8d2d", (Object[])new Object[0]);
        Set<Object> userAccounts = Sets.newHashSet();
        Set<Object> orgCodes = Sets.newHashSet();
        if (ShoppingGuideSelectMethodEnum.PART.getDictCode().equals(createSelectMethod)) {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)attendanceShiftDto.getShiftOrganizationRelationships()) ? 1 : 0) != 0, (String)"\u9009\u62e9\u90e8\u5206\u5bfc\u8d2d\u65f6\uff0c\u9009\u62e9\u7684\u7ec4\u7ec7\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            orgCodes = attendanceShiftDto.getShiftOrganizationRelationships().stream().map(AttendanceShiftOrganizationRelationshipDto::getOrgCode).collect(Collectors.toSet());
        }
        if (ShoppingGuideSelectMethodEnum.SPECIFIED.getDictCode().equals(createSelectMethod)) {
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)attendanceShiftDto.getShiftUserRelationships()) ? 1 : 0) != 0, (String)"\u9009\u62e9\u6307\u5b9a\u5bfc\u8d2d\u65f6\uff0c\u9009\u62e9\u7684\u5bfc\u8d2d\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            userAccounts = attendanceShiftDto.getShiftUserRelationships().stream().map(AttendanceShiftUserRelationshipDto::getUserAccount).collect(Collectors.toSet());
        }
        for (AttendanceShift attendanceShift : attendanceShifts) {
            HashSet orgCodeSet;
            List userVos;
            List<AttendanceShiftUserRelationship> userRels;
            Set currentOrgCodeSets;
            List<AttendanceShiftOrganizationRelationship> orgRels;
            String selectMethod = attendanceShift.getShoppingGuideSelectMethod();
            Validate.isTrue((!ShoppingGuideSelectMethodEnum.ALL.getDictCode().equals(selectMethod) ? 1 : 0) != 0, (String)"\u8be5\u73ed\u6b21\u7c7b\u578b\u5df2\u7ecf\u521b\u5efa\uff0c\u4e14\u5bf9\u6240\u6709\u5bfc\u8d2d\u6709\u6548", (Object[])new Object[0]);
            if (ShoppingGuideSelectMethodEnum.PART.getDictCode().equals(createSelectMethod)) {
                if (ShoppingGuideSelectMethodEnum.PART.getDictCode().equals(selectMethod)) {
                    orgRels = this.attendanceShiftOrganizationRelationshipService.findByShiftCode(attendanceShift.getShiftCode());
                    currentOrgCodeSets = orgRels.stream().map(AttendanceShiftOrganizationRelationship::getOrgCode).collect(Collectors.toSet());
                    Validate.isTrue((boolean)Sets.intersection((Set)orgCodes, currentOrgCodeSets).isEmpty(), (String)String.format("\u9009\u62e9\u7684\u7ec4\u7ec7\u673a\u6784\u4e0e\u5df2\u7ecf\u521b\u5efa\u7684 %s \u73ed\u6b21\u9009\u62e9\u7684\u7ec4\u7ec7\u673a\u6784\u6709\u91cd\u590d", attendanceShift.getShiftCode()), (Object[])new Object[0]);
                }
                if (ShoppingGuideSelectMethodEnum.SPECIFIED.getDictCode().equals(selectMethod)) {
                    userRels = this.attendanceShiftUserRelationshipService.findByShiftCode(attendanceShift.getShiftCode());
                    ArrayList accounts = new ArrayList();
                    userRels.stream().forEach(u -> accounts.add(u.getUserAccount()));
                    userVos = this.userFeignVoService.findByUserNames(accounts);
                    orgCodeSet = Sets.newHashSet();
                    for (UserVo userVo : userVos) {
                        if (CollectionUtils.isEmpty((Collection)userVo.getPositionList())) continue;
                        userVo.getPositionList().stream().filter(p -> !CollectionUtils.isEmpty((Collection)p.getOrgCodes())).forEach(p -> orgCodeSet.addAll(p.getOrgCodes()));
                    }
                    Validate.isTrue((boolean)Sets.intersection((Set)orgCodeSet, (Set)orgCodes).isEmpty(), (String)String.format("\u9009\u62e9\u7684\u7ec4\u7ec7\u673a\u6784\u4e0e\u5df2\u7ecf\u521b\u5efa\u7684 %s \u73ed\u6b21\u9009\u62e9\u7684\u5bfc\u8d2d\u7528\u6237\u6240\u5c5e\u7684\u7ec4\u7ec7\u673a\u6784\u6709\u91cd\u590d", attendanceShift.getShiftCode()), (Object[])new Object[0]);
                }
            }
            if (!ShoppingGuideSelectMethodEnum.SPECIFIED.getDictCode().equals(createSelectMethod)) continue;
            if (ShoppingGuideSelectMethodEnum.SPECIFIED.getDictCode().equals(selectMethod)) {
                userRels = this.attendanceShiftUserRelationshipService.findByShiftCode(attendanceShift.getShiftCode());
                Set currentUserAccountSets = userRels.stream().map(AttendanceShiftUserRelationship::getUserAccount).collect(Collectors.toSet());
                Validate.isTrue((boolean)Sets.intersection(currentUserAccountSets, (Set)userAccounts).isEmpty(), (String)String.format("\u9009\u62e9\u7684\u5bfc\u8d2d\u7528\u6237\u4e0e\u5df2\u7ecf\u521b\u5efa\u7684 %s \u73ed\u6b21\u9009\u62e9\u7684\u5bfc\u8d2d\u7528\u6237\u6709\u91cd\u590d", attendanceShift.getShiftCode()), (Object[])new Object[0]);
            }
            if (!ShoppingGuideSelectMethodEnum.PART.getDictCode().equals(selectMethod)) continue;
            orgRels = this.attendanceShiftOrganizationRelationshipService.findByShiftCode(attendanceShift.getShiftCode());
            currentOrgCodeSets = orgRels.stream().map(AttendanceShiftOrganizationRelationship::getOrgCode).collect(Collectors.toSet());
            userVos = this.userFeignVoService.findByUserNames(new ArrayList(userAccounts));
            orgCodeSet = Sets.newHashSet();
            for (UserVo userVo : userVos) {
                if (CollectionUtils.isEmpty((Collection)userVo.getPositionList())) continue;
                userVo.getPositionList().stream().filter(o -> !CollectionUtils.isEmpty((Collection)o.getOrgCodes())).forEach(p -> orgCodeSet.addAll(p.getOrgCodes()));
            }
            Validate.isTrue((boolean)Sets.intersection((Set)orgCodeSet, currentOrgCodeSets).isEmpty(), (String)String.format("\u9009\u62e9\u7684\u5bfc\u8d2d\u7528\u6237\u6240\u5c5e\u7684\u7ec4\u7ec7\u673a\u6784\u4e0e\u5df2\u7ecf\u521b\u5efa\u7684 %s \u73ed\u6b21\u9009\u62e9\u7684\u7ec4\u7ec7\u673a\u6784\u6709\u91cd\u590d", attendanceShift.getShiftCode()), (Object[])new Object[0]);
        }
    }

    private String buildShiftName(AttendanceShift attendanceShift) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat format = new SimpleDateFormat("HH:mm");
        String shiftType = attendanceShift.getShiftType();
        Date workStartTime = attendanceShift.getWorkStartTime();
        Date workEndTime = attendanceShift.getWorkEndTime();
        ShiftTypeEnum shiftTypeEnum = ShiftTypeEnum.getByDictCode((String)shiftType);
        Validate.notNull((Object)shiftTypeEnum, (String)"\u672a\u77e5\u7684\u73ed\u6b21\u7c7b\u578b", (Object[])new Object[0]);
        sb.append(shiftTypeEnum.getValue());
        sb.append(" ");
        sb.append(format.format(workStartTime));
        sb.append("-");
        sb.append(format.format(workEndTime));
        sb.append(" ");
        if (attendanceShift.getAcrossDay().booleanValue()) {
            sb.append("(\u8de8\u5929)");
        }
        return sb.toString();
    }
}

