package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 考勤结果枚举
 * @Author dy
 * @DATE 2022/3/3
 **/
public enum AttendanceStatusEnum {

  NORMAL("normal","1","正常","1"),
  LATE("late","2","迟到","2"),
  LEAVE_EARLY("leaveEarly","3","早退","3"),
  LATE_AND_LEAVE_EARLY("lateAndLeaveEarly","4","考勤异常","4"),
  NOT_CLOCK_IN("notClockIn","5","上班未打卡","5"),
  NOT_CLOCK_OUT("notClockOut","6","下班未打卡","6"),
  NOT_CLOCK("notClock","7","未打卡","7"),
  DONT_NEED_CLOCK("dontNeedClock","8","不需要打卡","8");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  AttendanceStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static AttendanceStatusEnum getByKey(String key) {
    return Arrays.stream(AttendanceStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static AttendanceStatusEnum getByValue(String value) {
    return Arrays.stream(AttendanceStatusEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }
}
