package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 打卡状态枚举
 * @Author dy
 * @DATE 2022/2/11
 **/
public enum ClockStatusEnum {

  // 正常 ，迟到，早退,未打卡
  NORMAL("normal","1","正常","1"),
  LATE("late","2","迟到","2"),
  LEAVE_EARLY("leaveEarly","3","早退","3"),
  NOT_CLOCK("notClock","4","未打卡","4");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ClockStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static ClockStatusEnum getByKey(String key) {
    return Arrays.stream(ClockStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static ClockStatusEnum getByValue(String value) {
    return Arrays.stream(ClockStatusEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }
}
