package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 签到类型枚举
 * @Author dy
 * @DATE 2022/2/11
 **/
public enum ClockTypeEnum {

  // 上班签到 下班签退
  CLOCK_IN("clockIn","1","上班打卡","1"),
  CLOCK_OUT("clockOut","2","下班打卡","2");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ClockTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static ClockTypeEnum getByKey(String key) {
    return Arrays.stream(ClockTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static ClockTypeEnum getByValue(String value) {
    return Arrays.stream(ClockTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }
}
