package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 调休类型枚举
 * @Author dy
 * @DATE 2022/2/11
 **/
public enum CompensatoryLeaveTypeEnum {

  // 不包含调休，当天调休，跨天调休
  NOT_COMPENSATORY_LEAVE("notCompensatoryLeave","1","不包含调休","1"),
  ON_DAY_COMPENSATORY_LEAVE("onDayCompensatoryLeave","2","当天调休","2"),
  ACROSS_DAY_COMPENSATORY_LEAVE("day_compensatory","3","跨天调休","3");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  CompensatoryLeaveTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static CompensatoryLeaveTypeEnum getByKey(String key) {
    return Arrays.stream(CompensatoryLeaveTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static CompensatoryLeaveTypeEnum getByValue(String value) {
    return Arrays.stream(CompensatoryLeaveTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
            .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }
}
