package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 排班申请审核状态枚举
 * @Author dy
 * @DATE 2022/3/1
 **/
public enum ShiftApplicationAuditStatusEnum {

  NO_AUDIT("notAudit","1","未审核","1"),
  REJECTED("rejected","2","审核驳回","2"),
  PASS("pass","3","审核通过","3");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ShiftApplicationAuditStatusEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static ShiftApplicationAuditStatusEnum getByKey(String key) {
    return Arrays.stream(ShiftApplicationAuditStatusEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static ShiftApplicationAuditStatusEnum getByValue(String value) {
    return Arrays.stream(ShiftApplicationAuditStatusEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
        .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }


}
