package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 排班类型枚举
 * @Author dy
 * @DATE 2022/2/18
 **/
public enum ShiftPlanTypeEnum {
  // 早班，中班，晚班，全天调休,周末或节假日休息
  MORNING_SHIFT("morning_shift","1","早班","1"),
  MIDDLE_SHIFT("middle_shift","2","中班","2"),
  NIGHT_SHIFT("night_shift","3","晚班","3"),
  DAY_COMPENSATORY_LEAVE("day_compensatory_leave","4","全天调休","4"),
  REST_DAY("rest_day","5","休息日","5"),
  EXPIRY_DATE("expiry_date","6","日期过期","6");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ShiftPlanTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static ShiftPlanTypeEnum getByKey(String key) {
    return Arrays.stream(ShiftPlanTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static ShiftPlanTypeEnum getByValue(String value) {
    return Arrays.stream(ShiftPlanTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
            .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }
}
