package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 班次类型枚举
 * @Author dy
 * @DATE 2022/2/10
 **/
public enum ShiftTypeEnum {

  // 早班，中班，晚班,全天调休
  MORNING_SHIFT("morningShift","1","早班","1"),
  MIDDLE_SHIFT("middleShift","2","中班","2"),
  NIGHT_SHIFT("nightShift","3","晚班","3"),
  DAY_COMPENSATORY_LEAVE("dayCompensatoryLeave","4","全天调休","4");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ShiftTypeEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static ShiftTypeEnum getByKey(String key) {
    return Arrays.stream(ShiftTypeEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }

  /**
   * 通过dictCode 获取 ShiftTypeEnum
   * @param dictCode
   * @return
   */
  public static ShiftTypeEnum getByDictCode(String dictCode){
    return Arrays.stream(ShiftTypeEnum.values()).filter(item -> Objects.equals(item.getDictCode(), dictCode))
        .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static ShiftTypeEnum getByValue(String value) {
    return Arrays.stream(ShiftTypeEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
            .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }

}
