package com.biz.crm.cps.business.attendance.sdk.common.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * 导购选择方式枚举
 * @Author dy
 * @DATE 2022/2/10
 **/
public enum ShoppingGuideSelectMethodEnum {

  // 全部导购 部分导购 指定导购

  ALL("all","1", "全部导购","1"),
  PART("part","2", "部分导购","2"),
  SPECIFIED("specified","3", "指定导购","3");

  private String key;
  /**
   * 字典编码
   */
  private String dictCode;
  /**
   * 字典值
   */
  private String value;
  /**
   * 字典排序
   */
  private String order;

  ShoppingGuideSelectMethodEnum(String key, String dictCode, String value, String order) {
    this.key = key;
    this.dictCode = dictCode;
    this.order = order;
    this.value = value;
  }

  /**
   * 通过key获取 SignatoryEnum
   *
   * @param key
   * @return
   */
  public static ShoppingGuideSelectMethodEnum getByKey(String key) {
    return Arrays.stream(ShoppingGuideSelectMethodEnum.values()).filter(item -> Objects.equals(item.getKey(), key))
            .findFirst().orElse(null);
  }

  /**
   * 通过flag获取 SignatoryEnum
   *
   * @param value
   * @return
   */
  public static ShoppingGuideSelectMethodEnum getByValue(String value) {
    return Arrays.stream(ShoppingGuideSelectMethodEnum.values()).filter(item -> Objects.equals(item.getValue(), value))
            .findFirst().orElse(null);
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getValue() {
    return value;
  }

  public void setValue(String value) {
    this.value = value;
  }

  public String getOrder() {
    return order;
  }

  public void setOrder(String order) {
    this.order = order;
  }
}
