package com.biz.crm.cps.business.attendance.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;

/**
 * 导购打卡Dto
 * @Author dy
 * @DATE 2022/3/7
 **/
@ApiModel("打卡Dto")
@Data
public class AttendanceClockDto implements Serializable {

  @ApiModelProperty("打卡类型")
  private String clockType;

  @ApiModelProperty("打卡经度")
  private BigDecimal longitude;

  @ApiModelProperty("打卡纬度")
  private BigDecimal latitude;

  @ApiModelProperty("地址编码")
  private String clockAddressCode;

  @ApiModelProperty("打卡详细地址地址")
  private String clockAddress;

  @ApiModelProperty("职位编码")
  private String positionCode;

  @ApiModelProperty("职位名称")
  private String positionName;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  private String orgName;

  @ApiModelProperty("打卡备注")
  private String remark;

  @ApiModelProperty("打卡图片")
  private Set<AttendanceClockPictureDto> pictures;
}
