package com.biz.crm.cps.business.attendance.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 考勤明细查询Dto
 * @Author dy
 * @DATE 2022/3/3
 **/
@ApiModel("考勤明细查询Dto")
@Data
public class AttendanceDetailConditionDto implements Serializable {

  private static final long serialVersionUID = -2636377134515827400L;

  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd")
  @ApiModelProperty("考勤日期")
  private Date attendanceDate;

  @ApiModelProperty("用户编码")
  private String userCode;

  @ApiModelProperty("用户账号")
  private String userAccount;

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("考勤状态")
  private String attendanceStatus;
}
