package com.biz.crm.cps.business.attendance.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 排班申请Dto
 * @Author dy
 * @DATE 2022/2/18
 **/
@Data
@ApiModel("排班申请Dto")
public class AttendanceShiftApplicationDto implements Serializable {

  private static final long serialVersionUID = 7571435273733080729L;

  @ApiModelProperty("排班申请id")
  private String id;

  @ApiModelProperty("排班申请编码")
  private String applyCode;

  @ApiModelProperty("审核状态")
  private String auditStatus;

  @ApiModelProperty("驳回原因")
  private String rejectedReason;

  @ApiModelProperty("申请排班开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date applyStartDate;

  @ApiModelProperty("申请排班结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date applyEndDate;

  @ApiModelProperty("联系电话")
  private String contactPhone;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  private String orgName;

  @ApiModelProperty("排班计划详情")
  private List<AttendanceShiftPlanDto> shiftPlans;
}
