package com.biz.crm.cps.business.attendance.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;

/**
 * @Author dy
 * @DATE 2022/2/18
 **/
@Data
@ApiModel("班次Dto")
public class AttendanceShiftDto implements Serializable {

  private static final long serialVersionUID = 4072953341646151266L;

  @ApiModelProperty("班次id")
  private String id;

  @ApiModelProperty("班次编码")
  private String shiftCode;

  @ApiModelProperty("班次名称")
  private String shiftName;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftTypeEnum}
   */
  @ApiModelProperty("班次类型")
  private String shiftType;

  @ApiModelProperty("班次描述")
  private String shiftDescribe;

  @ApiModelProperty("班次标识颜色")
  private String shiftColor;

  @ApiModelProperty("启用状态")
  private String enableStatus;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShoppingGuideSelectMethodEnum}
   */
  @ApiModelProperty("导购选择方式")
  private String shoppingGuideSelectMethod;

  @ApiModelProperty("班次与组织关联对象")
  private Set<AttendanceShiftOrganizationRelationshipDto> shiftOrganizationRelationships;

  @ApiModelProperty("班次与导购用户关联对象")
  private Set<AttendanceShiftUserRelationshipDto> shiftUserRelationships;

  @ApiModelProperty("是否跨天班次")
  private Boolean acrossDay;

  @ApiModelProperty("工作开始时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date workStartTime;

  @ApiModelProperty("最晚签到时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date latestSignInTime;

  @ApiModelProperty("工作结束时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date workEndTime;

  @ApiModelProperty("最早签退时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date earliestSignBackTime;
}
