package com.biz.crm.cps.business.attendance.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author dy
 * @DATE 2022/2/18
 **/
@Data
@ApiModel("排班计划Dto")
public class AttendanceShiftPlanDto implements Serializable {

  private static final long serialVersionUID = 1280639311490225916L;

  @ApiModelProperty("排班日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  private Date schedulingDate;

  @ApiModelProperty("是否是有效日期,即排班日期是否在申请日期之前")
  private Boolean effectiveDate;

  @ApiModelProperty("班次编码")
  private String shiftCode;

  @ApiModelProperty("终端编码")
  private String terminalCode;

  @ApiModelProperty("终端名称")
  private String terminalName;

  @ApiModelProperty("终端类型")
  private String terminalType;

  @ApiModelProperty("是否是节假日")
  private Boolean holiday;

  @ApiModelProperty("节日名称")
  private String festivalName;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.CompensatoryLeaveTypeEnum}
   */
  @ApiModelProperty("调休类型")
  private String compensatoryLeaveType;

  @ApiModelProperty("调休开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm",locale="zh", timezone="GMT+8")
  private Date compensatoryLeaveStartDate;

  @ApiModelProperty("调休结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm",locale="zh", timezone="GMT+8")
  private Date compensatoryLeaveEndDate;
}
