package com.biz.crm.cps.business.attendance.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 *  班次与导购用户关联Dto
 * @Author dy
 * @DATE 2022/2/18
 **/
@Data
@ApiModel("班次与导购用户关联Dto")
public class AttendanceShiftUserRelationshipDto implements Serializable {

  @ApiModelProperty("班次编码")
  private String shiftCode;

  @ApiModelProperty("导购用户编码")
  private String userCode;

  @ApiModelProperty("导购用户名称")
  private String userName;

  @ApiModelProperty("导购用户账号")
  private String userAccount;

  @ApiModelProperty("导购用户类型")
  private String userType;

  /**
   * 所属组织编码
   */
  @ApiModelProperty("导购所属组织编码")
  private String orgCode;

  /**
   * 所属组织名称
   */
  @ApiModelProperty("导购所属组织名称")
  private String orgName;
}
