package com.biz.crm.cps.business.attendance.sdk.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * 排班申请查询Dto
 * @Author dy
 * @DATE 2022/2/17
 **/
@Data
@ApiModel(value = "ShiftApplicationConditionDto", description = "排班申请查询Dto")
public class ShiftApplicationConditionDto implements Serializable {

  private static final long serialVersionUID = 5866556508600390088L;

  @ApiModelProperty("组织编码")
  private String orgCode;

  @ApiModelProperty("组织名称")
  private String orgName;

  @ApiModelProperty("导购编码")
  private String userCode;

  @ApiModelProperty("导购名称")
  private String userName;

  @ApiModelProperty("导购员账号")
  private String userAccount;

  @ApiModelProperty("审核状态")
  private String auditStatus;

  @ApiModelProperty("申请排班开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date applyStartDate;

  @ApiModelProperty("申请排班结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date applyEndDate;

  @ApiModelProperty("提交申请开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date commitApplyStartDate;

  @ApiModelProperty("提交申请结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date commitApplyEndDate;

  @ApiModelProperty("审核开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date auditStartDate;

  @ApiModelProperty("审核结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  @DateTimeFormat(pattern="yyyy-MM-dd")
  private Date auditEndDate;
}
