package com.biz.crm.cps.business.attendance.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import org.springframework.data.domain.Pageable;

import java.util.Date;

/**
 * 排班申请Vo Service接口定义
 * @Author dy
 * @DATE 2022/2/18
 **/
public interface AttendanceShiftApplicationVoService {

  /**
   * 分页条件查询排班申请
   * @param pageable 分页信息
   * @param shiftApplicationConditionDto 分页查询dto
   * @return 分页返回信息
   */
  Page<AttendanceShiftApplicationVo> findDetailsByConditions(Pageable pageable, ShiftApplicationConditionDto shiftApplicationConditionDto);

  /**
   * 根据Id查询班次详情
   * @param id
   * @return
   */
  AttendanceShiftApplicationVo findDetailsById(String id);

  /**
   * 根据编码查询班次详情
   * @param applyCode
   * @return
   */
  AttendanceShiftApplicationVo findDetailsByApplyCode(String applyCode);

  /**
   * 根据当前登录用户账号和申请周期查询，applyPeriodDate可选周期内的任意一天
   * @param applyPeriodDate
   * @return
   */
  AttendanceShiftApplicationVo findByCurrentUserAndApplyPeriodDate(Date applyPeriodDate);

  /**
   * 根据导购用户账号和查询当日排班计划
   * @param date
   * @return
   */
  AttendanceShiftApplicationVo findByCurrentUserAndDate(Date date);
}
