package com.biz.crm.cps.business.attendance.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftApplicationConditionDto;
import com.biz.crm.cps.business.attendance.sdk.dto.ShiftConditionDto;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftApplicationVo;
import com.biz.crm.cps.business.attendance.sdk.vo.AttendanceShiftVo;
import org.springframework.data.domain.Pageable;

/**
 * 班次管理Vo Service接口定义
 * @Author dy
 * @DATE 2022/2/18
 **/
public interface AttendanceShiftVoService {

  /**
   * 根据Id查询班次信息
   * @param id
   * @return
   */
  AttendanceShiftVo findDetailsById(String id);

  /**
   * 根据编码查询班次信息
   * @param shiftCode
   * @return
   */
  AttendanceShiftVo findDetailsByShiftCode(String shiftCode);

  /**
   * 分页条件查询班次信息
   * @param pageable 分页信息
   * @param shiftConditionDto 分页查询dto
   * @return 分页返回信息
   */
  Page<AttendanceShiftVo> findDetailsByConditions(Pageable pageable, ShiftConditionDto shiftConditionDto);
}
