package com.biz.crm.cps.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * 考勤历史Vo
 * @Author dy
 * @DATE 2022/3/14
 **/
@Data
@ApiModel("考勤打卡历史Vo")
public class AttendanceClockVo extends TenantFlagOpVo {

  @ApiModelProperty("考勤日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd")
  private Date attendanceDate;

  @ApiModelProperty("打卡时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date clockDate;

  @ApiModelProperty("打卡类型")
  private String clockType;

  @ApiModelProperty("打卡状态")
  private String clockStatus;

  @ApiModelProperty("打卡经度")
  private BigDecimal longitude;

  @ApiModelProperty("打卡纬度")
  private BigDecimal latitude;

  @ApiModelProperty("打卡详细地址地址")
  private String clockAddress;

  @ApiModelProperty("打卡地址编码")
  private String clockAddressCode;

  @ApiModelProperty("打卡人员姓名")
  private String userName;

  @ApiModelProperty("打卡人员账号")
  private String userAccount;

  @ApiModelProperty("打卡用户编码")
  private String userCode;

  @ApiModelProperty("职位编码")
  private String positionCode;

  @ApiModelProperty("职位名称")
  private String positionName;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  private String orgName;

  @ApiModelProperty("打卡图片")
  private Set<AttendanceClockPictureRelationVo> pictures;
}
