package com.biz.crm.cps.business.attendance.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 考勤报表Vo
 * @Author dy
 * @DATE 2022/3/3
 **/
@ApiModel("考勤报表Vo")
@Data
public class AttendanceDetailReportVo{

  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  @ApiModelProperty("创建日期")
  private Date createTime;

  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd")
  @ApiModelProperty("考勤日期")
  private Date attendanceDate;

  @ApiModelProperty("目标总工时")
  private BigDecimal totalGoalWorkHours;

  @ApiModelProperty("实际总工时")
  private BigDecimal totalRealWorkHours;

  @ApiModelProperty("总调休时长")
  private BigDecimal totalCompensatoryLeaveLength;

  @ApiModelProperty("正常考勤人数")
  private int normalAttendanceCount;

  @ApiModelProperty("考勤迟到人数")
  private int lateAttendanceCount;

  @ApiModelProperty("考勤早退人数")
  private int leaveEarlyAttendanceCount;

  @ApiModelProperty("上班未打卡人数")
  private int notClockInCount;

  @ApiModelProperty("下班未打卡人数")
  private int notClockOutCount;

  @ApiModelProperty("考勤异常人数(上班迟到且早退的)")
  private int lateAndLeaveEarlyCount;

  @ApiModelProperty("未打卡人数（上下班都没有打卡）")
  private int notClockCount;
}
