package com.biz.crm.cps.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 排班申请Vo
 * @Author dy
 * @DATE 2022/2/18
 **/
@ApiModel("排班申请Vo")
@Data
public class AttendanceShiftApplicationVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 1607261553633132325L;

  @ApiModelProperty("排班申请编码")
  private String applyCode;

  @ApiModelProperty("发起申请时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date applyDate;

  @ApiModelProperty("申请排班开始时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  private Date applyStartDate;

  @ApiModelProperty("申请排班结束时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  private Date applyEndDate;

  @ApiModelProperty("审核时间")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd HH:mm:ss")
  private Date auditDate;

  @ApiModelProperty("联系电话")
  private String contactPhone;

  @ApiModelProperty("申请排班用户编码")
  private String userCode;

  @ApiModelProperty("申请排班用户账号")
  private String userAccount;

  @ApiModelProperty("申请排班用户名称")
  private String userName;

  @ApiModelProperty("申请排班用户类型")
  private String userType;

  @ApiModelProperty("所属组织编码")
  private String orgCode;

  @ApiModelProperty("所属组织名称")
  private String orgName;

  @ApiModelProperty("审核状态")
  private String auditStatus;

  @ApiModelProperty("驳回原因")
  private String rejectedReason;

  @ApiModelProperty("排班申请详情")
  private List<AttendanceShiftPlanVo> shiftPlans;
}
