package com.biz.crm.cps.business.attendance.sdk.vo;

import com.biz.crm.cps.business.common.sdk.vo.BaseIdVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 排班计划Vo
 * @Author dy
 * @DATE 2022/2/18
 **/
@ApiModel("排班计划Vo")
@Data
public class AttendanceShiftPlanVo extends BaseIdVo {

  private static final long serialVersionUID = 1783795893129729701L;

  @ApiModelProperty("排班日期")
  @DateTimeFormat(pattern = "yyyy-MM-dd")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern="yyyy-MM-dd")
  private Date schedulingDate;

  @ApiModelProperty("是否是有效日期,即排班日期是否在申请日期之前")
  private Boolean effectiveDate;

  @ApiModelProperty("排班申请编码")
  private String applyCode;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftPlanTypeEnum}
   */
  @ApiModelProperty("排班类型")
  private String shiftPlanType;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftTypeEnum}
   */
  @ApiModelProperty("班次类型")
  private String shiftType;

  @ApiModelProperty("是否是节假日或周末")
  private Boolean holiday;

  @ApiModelProperty("节日名称")
  private String festivalName;

  @ApiModelProperty("星期")
  private Integer week;

  @ApiModelProperty("班次编码")
  private String shiftCode;

  @ApiModelProperty("班次名称")
  private String shiftName;

  @ApiModelProperty("班次描述")
  private String shiftDescribe;

  @ApiModelProperty("班次标识颜色")
  private String shiftColor;

  @ApiModelProperty("是否跨天班次")
  private Boolean acrossDay;

  @ApiModelProperty("上班时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date workStartDate;

  @ApiModelProperty("最晚签到时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date latestSignInDate;

  @ApiModelProperty("下班时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date workEndDate;

  @ApiModelProperty("最早签退时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
  private Date earliestSignBackDate;

  @ApiModelProperty("终端编码")
  private String terminalCode;

  @ApiModelProperty("终端名称")
  private String terminalName;

  @ApiModelProperty("终端类型")
  private String terminalType;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.CompensatoryLeaveTypeEnum}
   */
  @ApiModelProperty("调休类型")
  private String compensatoryLeaveType;

  @ApiModelProperty("调休开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm")
  private Date compensatoryLeaveStartDate;

  @ApiModelProperty("调休结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8",pattern = "yyyy-MM-dd HH:mm")
  private Date compensatoryLeaveEndDate;

  @ApiModelProperty("调休时长")
  private BigDecimal compensatoryLeaveLength;

  @ApiModelProperty("正常工作时长")
  private BigDecimal normalWorkHours;
}
