package com.biz.crm.cps.business.attendance.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Set;

/**
 * 班次管理Vo
 * @Author dy
 * @DATE 2022/2/18
 **/
@Data
@ApiModel("班次管理Vo")
public class AttendanceShiftVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 1000803967463352205L;

  @ApiModelProperty("班次编码")
  private String shiftCode;

  @ApiModelProperty("班次名称")
  private String shiftName;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShiftTypeEnum}
   */
  @ApiModelProperty("班次类型")
  private String shiftType;

  @ApiModelProperty("班次描述")
  private String shiftDescribe;

  @ApiModelProperty("班次标识颜色")
  private String shiftColor;

  /**
   * 枚举类型 {@link com.biz.crm.cps.business.attendance.sdk.common.enums.ShoppingGuideSelectMethodEnum}
   */
  @ApiModelProperty("导购选择方式")
  private String shoppingGuideSelectMethod;

  @ApiModelProperty("班次与组织关联对象")
  private Set<AttendanceShiftOrganizationRelationshipVo> shiftOrganizationRelationships;

  @ApiModelProperty("班次与导购用户关联对象")
  private Set<AttendanceShiftUserRelationshipVo> shiftUserRelationships;

  @ApiModelProperty("是否跨天班次")
  private Boolean acrossDay;

  @ApiModelProperty("工作开始时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date workStartTime;

  @ApiModelProperty("最晚签到时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date latestSignInTime;

  @ApiModelProperty("工作结束时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date workEndTime;

  @ApiModelProperty("最早签退时间")
  @DateTimeFormat(pattern = "HH:mm")
  @JsonFormat(locale="zh", timezone="GMT+8", pattern = "HH:mm")
  private Date earliestSignBackTime;
}
