package com.biz.crm.cps.business.capital.local.controller;


import com.biz.crm.cps.business.capital.local.entity.CapitalRecharge;
import com.biz.crm.cps.business.capital.local.service.CapitalRechargeService;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 充值信息(CapitalRecharge)表相关的http接口
 *
 * @author makejava
 * @since 2022-02-18 16:40:37
 */
@RestController
@RequestMapping("/v1/capital/recharge")
@Slf4j
@Api(tags = "资金管理:CapitalRecharge:充值信息")
public class CapitalRechargeController {
  /**
   * 服务对象
   */
  @Autowired
  private CapitalRechargeService capitalRechargeService;

  /**
   * 修改数据
   *
   * @param capitalRecharge 实体对象
   * @return 修改结果
   */
  @ApiOperation(value = "修改数据")
  @PatchMapping
  public Result<CapitalRecharge> update(@ApiParam(name = "capitalRecharge", value = "充值信息") @RequestBody CapitalRecharge capitalRecharge) {
    try {
      CapitalRecharge result = this.capitalRechargeService.update(capitalRecharge);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  @DeleteMapping
  public Result<?> delete(@ApiParam(name = "idList", value = "主键集合") @RequestParam("idList") List<String> idList) {
    try {
      this.capitalRechargeService.delete(idList);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
