package com.biz.crm.cps.business.capital.local.controller;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.capital.sdk.dto.CpsRaiseRechargeAuditDto;
import com.biz.crm.cps.business.capital.sdk.dto.CpsRaiseRechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import com.biz.crm.cps.business.capital.sdk.dto.UserAccountRechargeDto;
import com.biz.crm.cps.business.capital.sdk.service.CapitalRechargeVoService;
import com.biz.crm.cps.business.capital.sdk.service.RechargeMountVoService;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import com.biz.crm.cps.business.capital.sdk.vo.RechargeMountVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 充值信息(CapitalRecharge)表相关的http接口
 *
 * @author makejava
 * @since 2022-02-18 16:40:37
 */
@RestController
@RequestMapping("/v1/capital/recharge")
@Slf4j
@Api(tags = "资金管理:CapitalRechargeVo:充值信息")
public class CapitalRechargeVoController {
  /**
   * 服务对象
   */
  @Autowired
  private CapitalRechargeVoService capitalRechargeVoService;
  @Autowired
  private RechargeMountVoService rechargeMountVoService;

  /**
   * 分页查询所有数据
   *
   * @param pageable 分页对象
   * @param dto      查询dto
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询所有数据")
  @GetMapping("findByConditions")
  public Result<Page<CapitalRechargeVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dto", value = "查询dto") RechargeQueryDto dto) {
    try {
      Page<CapitalRechargeVo> page = this.capitalRechargeVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 分页查询当前用户账户的充值信息
   *
   * @param pageable 分页对象
   * @param dto      查询dto
   * @return 所有数据
   */
  @ApiOperation(value = "分页查询当前用户账户的充值信息")
  @GetMapping("findCurrentUserByConditions")
  public Result<Page<CapitalRechargeVo>> findCurrentUserByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                          @ApiParam(name = "dto", value = "查询dto") RechargeQueryDto dto) {
    try {
      Page<CapitalRechargeVo> page = this.capitalRechargeVoService.findCurrentUserByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  @ApiOperation(value = "通过主键查询单条数据")
  @GetMapping("{id}")
  public Result<CapitalRechargeVo> findById(@PathVariable @ApiParam(name = "id", value = "主键id") String id) {
    try {
      CapitalRechargeVo capitalRechargeVo = this.capitalRechargeVoService.findById(id);
      return Result.ok(capitalRechargeVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 新增数据
   *
   * @param rechargeDto 充值信息dto
   * @return 新增结果
   */
  @ApiOperation(value = "新增数据")
  @PostMapping
  public Result<?> create(@ApiParam(name = "rechargeDto", value = "充值信息") @RequestBody RechargeDto rechargeDto) {
    try {
      this.capitalRechargeVoService.create(rechargeDto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据用户商户平台账号新增数据(小程序用)
   *
   * @param dto 充值信息dto
   * @return 新增结果
   */
  @ApiOperation(value = "根据用户商户平台账号新增数据(小程序用)")
  @PostMapping("createByCurrentUser")
  public Result<?> createByCurrentUser(@ApiParam(name = "dto", value = "充值信息") @RequestBody UserAccountRechargeDto dto) {
    try {
      this.capitalRechargeVoService.createByCurrentUser(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询系统中存在的充值模块信息
   */
  @ApiOperation(value = "查询系统中存在的充值模块信息")
  @GetMapping(value = "/findRecharge")
  public Result<List<RechargeMountVo>> findRecharge() {
    try {
      List<RechargeMountVo> current = this.rechargeMountVoService.findRecharge();
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 税筹平台充值审核状态同步
   *
   * @param dto 充值审核状态同步dto
   * @return 新增结果
   */
  @ApiOperation(value = "充值审核状态同步")
  @PatchMapping("updateAuditStatusByAuditDto")
  public Result<?> updateAuditStatusByAuditDto(@ApiParam(name = "rechargeDto", value = "充值审核状态同步dto") @RequestBody CpsRaiseRechargeAuditDto dto) {
    try {
      this.capitalRechargeVoService.updateAuditStatusByAuditDto(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 批量新增数据(税筹平台用)
   *
   * @param dto 充值信息dto
   * @return 新增结果
   */
  @ApiOperation(value = "批量新增数据(税筹平台用)")
  @PostMapping("createBatch")
  public Result<?> createBatch(@ApiParam(name = "dto", value = "充值信息") @RequestBody CpsRaiseRechargeDto dto) {
    try {
      this.capitalRechargeVoService.createBatch(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
