package com.biz.crm.cps.business.capital.local.controller;


import com.biz.crm.cps.business.capital.sdk.service.RechargeProcessVoService;
import com.biz.crm.cps.business.capital.sdk.vo.RechargeProcessVo;
import com.biz.crm.cps.business.common.local.model.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 资金管理:RechargeProcessVo:充值流程信息
 *
 * @author ning.zhang
 * @date 2022/3/31
 */
@RestController
@RequestMapping("/v1/capital/rechargeProcess")
@Slf4j
@Api(tags = "资金管理:RechargeProcessVo:充值流程信息")
public class RechargeProcessVoController {

  @Autowired
  private RechargeProcessVoService rechargeProcessVoService;

  /**
   * 查询当前用户充值流程
   *
   * @return 当前用户充值流程
   */
  @ApiOperation(value = "当前用户充值流程")
  @GetMapping("findByCurrentUser")
  public Result<RechargeProcessVo> findProcessByCurrentUser() {
    try {
      RechargeProcessVo vo = this.rechargeProcessVoService.findProcessByCurrentUser();
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
