package com.biz.crm.cps.business.capital.local.entity;


import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 充值信息
 *
 * @Author: wjx
 * @Date: 2022/2/15 11:39
 */
@Entity
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "CapitalRecharge", description = "充值信息")
@TableName("capital_recharge")
@Table(name = "`capital_recharge`")
@org.hibernate.annotations.Table(appliesTo = "`capital_recharge`", comment = "充值信息")
public class CapitalRecharge extends TenantFlagOpEntity {

  /**
   * 充值编码
   */
  @Column(name = "recharge_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 充值编码 '")
  @ApiModelProperty("充值编码")
  @TableField(value = "recharge_code")
  private String rechargeCode;


  //充值提示信息

  /**
   * 充值提示编码 (查询充值渠道信息)
   */
  @Column(name = "recharge_tip_code", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 充值提示编码 '")
  @ApiModelProperty("充值提示编码")
  @TableField(value = "recharge_tip_code")
  private String rechargeTipCode;


  //充值信息

  /**
   * 商户平台用户账户 (通过该编码+商户平台id 可查询税筹平台的账户userAccount)
   */
  @Column(name = "merchant_user_account", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 商户平台用户账户 '")
  @ApiModelProperty("商户平台用户账户")
  @TableField(value = "merchant_user_account")
  private String merchantUserAccount;

  /**
   * 充值账户编码
   */
  @Column(name = "account_code", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 充值账户编码 '")
  @ApiModelProperty("充值账户编码")
  @TableField(value = "account_code")
  private String accountCode;

  /**
   * 充值账户名称
   */
  @Column(name = "account_name", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 充值账户名称 '")
  @ApiModelProperty("充值账户名称")
  @TableField(value = "account_name")
  private String accountName;

  /**
   * 充值金额
   */
  @Column(name = "recharge_amount", nullable = false, columnDefinition = "decimal(20,4) COMMENT ' 充值金额 '")
  @ApiModelProperty("充值金额")
  @TableField(value = "recharge_amount")
  private BigDecimal rechargeAmount;

  /**
   * 充值状态
   */
  @Column(name = "recharge_status", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 充值状态 '")
  @ApiModelProperty("充值状态")
  @TableField(value = "recharge_status")
  private String rechargeStatus;

  /**
   * 审核状态
   */
  @Column(name = "audit_status", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 审核状态 '")
  @ApiModelProperty("审核状态")
  @TableField(value = "audit_status")
  private String auditStatus;

  /**
   * 充值来源
   */
  @Column(name = "recharge_source", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 充值来源 '")
  @ApiModelProperty("充值来源")
  @TableField(value = "recharge_source")
  private String rechargeSource;

  /**
   * 充值时间
   */
  @Column(name = "recharge_time", nullable = true, columnDefinition = "datetime COMMENT ' 充值时间 '")
  @ApiModelProperty(name = "confirmTime", value = "充值时间")
  @TableField(value = "recharge_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date rechargeTime;

  /**
   * 确认时间
   */
  @Column(name = "confirm_time", nullable = true, columnDefinition = "datetime COMMENT ' 确认时间 '")
  @ApiModelProperty(name = "confirmTime", value = "确认时间")
  @TableField(value = "confirm_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date confirmTime;

  /**
   * 数据来源
   */
  @Column(name = "data_source", nullable = false, columnDefinition = "VARCHAR(64) COMMENT ' 数据来源 '")
  @ApiModelProperty("数据来源")
  @TableField(value = "data_source")
  private String dataSource;

  /**
   * 推送状态  CashPushStatusEnum
   *
   */
  @Column(name = "push_status", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 推送状态 '")
  @ApiModelProperty("推送状态")
  @TableField(value = "push_status")
  private String pushStatus;

  /**
   * 推送时间
   */
  @Column(name = "push_time", nullable = true, columnDefinition = "datetime COMMENT ' 推送时间 '")
  @ApiModelProperty(name = "pushTime", value = "推送时间")
  @TableField(value = "push_time")
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  private Date pushTime;

  /**
   * 推送关联单号
   */
  @Column(name = "push_code", nullable = true, columnDefinition = "VARCHAR(64) COMMENT ' 推送关联单号 '")
  @ApiModelProperty("推送关联单号")
  @TableField(value = "push_code")
  private String pushCode;

}
