package com.biz.crm.cps.business.capital.local.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import org.apache.ibatis.annotations.Param;

import java.util.Date;

/**
 * 资金账户充值相关mapper
 *
 * @Author: wjx
 * @Date: 2022/2/21 18:26
 */
public interface CapitalRechargeVoMapper {

  /**
   * 分页查询所有数据
   *
   * @param page 分页对象
   * @param dto  查询dto
   * @return 所有数据
   */
  Page<CapitalRechargeVo> findByConditions(@Param("page") Page<CapitalRechargeVo> page, @Param("dto") RechargeQueryDto dto);

  /**
   * 根据id查询详情
   * @param id
   * @return
   */
  CapitalRechargeVo findById(@Param("id") String id);

  /**
   * 根据充值编号更改充值状态
   * @param rechargeCode
   * @param auditStatus
   * @param rechargeStatus
   */
  void updateStatusByRechargeCode(@Param("rechargeCode") String rechargeCode,
                                  @Param("auditStatus")String auditStatus,
                                  @Param("rechargeStatus")String rechargeStatus,
                                  @Param("confirmTime") Date confirmTime);

  /**
   * 根据推送充值编号更改充值状态
   * @param pushCode
   * @param auditStatus
   * @param rechargeStatus
   */
  void updateStatusByPushCode(@Param("pushCode") String pushCode,
                                  @Param("auditStatus")String auditStatus,
                                  @Param("rechargeStatus")String rechargeStatus,
                                  @Param("confirmTime") Date confirmTime);
}
