package com.biz.crm.cps.business.capital.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.business.capital.local.entity.CapitalRecharge;
import com.biz.crm.cps.business.capital.local.mapper.CapitalRechargeMapper;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 充值信息(CapitalRecharge)表数据库访问层
 *
 * @author makejava
 * @since 2022-02-18 16:40:39
 */
@Component
public class CapitalRechargeRepository extends ServiceImpl<CapitalRechargeMapper, CapitalRecharge> {

  @Autowired
  private CapitalRechargeMapper capitalRechargeMapper;

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      查询dto
   * @return
   */
  public Page<CapitalRecharge> findByConditions(Pageable pageable, RechargeQueryDto dto) {
    Page<CapitalRecharge> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CapitalRecharge> pageList = capitalRechargeMapper.findByConditions(page, dto);
    return pageList;
  }

  /**
   * 根据充值编码和租户编码查询
   *
   * @param rechargeCode 充值编码
   * @param tenantCode   租户编码
   * @return
   */
  public CapitalRecharge findByRechargeCodeAndTenantCode(String rechargeCode, String tenantCode) {
    return this.lambdaQuery()
        .eq(CapitalRecharge::getRechargeCode, rechargeCode)
        .eq(CapitalRecharge::getTenantCode, tenantCode).one();
  }

  /**
   * 根据充值编码集合和租户编码查询
   *
   * @param rechargeCodes 充值编码集合
   * @param tenantCode   租户编码
   * @return
   */
  public List<CapitalRecharge> findByRechargeCodesAndTenantCode(List<String> rechargeCodes, String tenantCode) {
    return this.lambdaQuery()
        .in(CapitalRecharge::getRechargeCode, rechargeCodes)
        .eq(CapitalRecharge::getTenantCode, tenantCode).list();
  }
}

