package com.biz.crm.cps.business.capital.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.capital.local.mapper.CapitalRechargeVoMapper;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 资金账户充值相关数据库操作
 *
 * @Author: wjx
 * @Date: 2022/2/21 18:23
 */
@Component
public class CapitalRechargeVoRepository {

  @Autowired
  private CapitalRechargeVoMapper capitalRechargeVoMapper;


  /**
   * 根据条件分页查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  public Page<CapitalRechargeVo> findByConditions(Pageable pageable, RechargeQueryDto dto) {
    Page<CapitalRechargeVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<CapitalRechargeVo> selectPage = capitalRechargeVoMapper.findByConditions(page, dto);
    return selectPage;
  }

  /**
   * 根据id查询
   * @param id
   * @return
   */
  public CapitalRechargeVo findById(String id) {
    return capitalRechargeVoMapper.findById(id);
  }

  /**
   * 根据充值编号更改充值状态
   * @param rechargeCode
   * @param auditStatus
   * @param rechargeStatus
   */
  public void updateStatusByRechargeCode(String rechargeCode, String auditStatus, String rechargeStatus) {
    capitalRechargeVoMapper.updateStatusByRechargeCode(rechargeCode,auditStatus,rechargeStatus,new Date());
  }

  /**
   * 根据税筹推送充值编号更改充值状态
   * @param pushCode
   * @param auditStatus
   * @param rechargeStatus
   */
  public void updateStatusByPushCode(String pushCode, String auditStatus, String rechargeStatus) {
    capitalRechargeVoMapper.updateStatusByPushCode(pushCode,auditStatus,rechargeStatus,new Date());
  }
}
