package com.biz.crm.cps.business.capital.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.capital.local.entity.CapitalRecharge;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 充值信息(CapitalRecharge)表服务接口
 *
 * @author makejava
 * @since 2022-02-18 16:40:38
 */
public interface CapitalRechargeService {

  /**
   * 分页查询数据
   *
   * @param pageable 分页对象
   * @param dto      查询dto
   * @return
   */
  Page<CapitalRecharge> findByConditions(Pageable pageable, RechargeQueryDto dto);

  /**
   * 通过主键查询单条数据
   *
   * @param id 主键
   * @return 单条数据
   */
  CapitalRecharge findById(String id);

  /**
   * 新增数据
   *
   * @param capitalRecharge 充值信息
   * @return 新增结果
   */
  CapitalRecharge create(CapitalRecharge capitalRecharge);

  /**
   * 创建实体
   *
   * @param capitalRecharge 充值信息
   * @return 新增结果
   */
  CapitalRecharge createForm(CapitalRecharge capitalRecharge);

  /**
   * 修改新据
   *
   * @param capitalRecharge 实体对象
   * @return 修改结果
   */
  CapitalRecharge update(CapitalRecharge capitalRecharge);

  /**
   * 删除数据
   *
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 批量保存数据
   * @param capitalRecharges
   */
  List<CapitalRecharge> createBatch(List<CapitalRecharge> capitalRecharges);

  /**
   * 根据充值编码查询
   * @param rechargeCode
   * @return
   */
  CapitalRecharge findByRechargeCode(String rechargeCode);

  /**
   * 根据充值编码更改推送状态
   * @param rechargeCode
   */
  void updatePushStatusByRechargeCodes(List<String> rechargeCode);
}

