package com.biz.crm.cps.business.capital.local.service.internal;

import com.biz.crm.cps.business.capital.sdk.service.RechargeMountVoService;
import com.biz.crm.cps.business.capital.sdk.service.observer.RechargeMountRegister;
import com.biz.crm.cps.business.capital.sdk.vo.RechargeMountVo;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 充值类型模块挂载信息
 * @Author: wjx
 * @Date: 2022/3/1 18:05
 */
@Service
public class RechargeMountVoServiceImpl implements RechargeMountVoService {

  @Autowired(required = false)
  private List<RechargeMountRegister> rechargeMountRegisters;

  @Override
  public List<RechargeMountVo> findRecharge() {
    if (CollectionUtils.isEmpty(this.rechargeMountRegisters)) {
      return null;
    }
    List<RechargeMountVo> list = Lists.newLinkedList();
    for (RechargeMountRegister rechargeMountObserver : this.rechargeMountRegisters) {
      RechargeMountVo vo = new RechargeMountVo();
      vo.setFlag(rechargeMountObserver.getFlag());
      vo.setKey(rechargeMountObserver.getKey());
      vo.setName(rechargeMountObserver.getName());
      list.add(vo);
    }
    return list;
  }
}
