package com.biz.crm.cps.business.capital.local.service.internal;

import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.capital.local.config.CapitalRechargeProperties;
import com.biz.crm.cps.business.capital.local.config.RechargeProperties;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeConditionDto;
import com.biz.crm.cps.business.capital.sdk.service.RechargeProcessVoService;
import com.biz.crm.cps.business.capital.sdk.service.observer.RechargeServiceObserver;
import com.biz.crm.cps.business.capital.sdk.vo.RechargeProcessVo;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 充值流程VO接口实现类
 *
 * @author ning.zhang
 * @date 2022/3/31
 */
@Service
public class RechargeProcessVoServiceImpl implements RechargeProcessVoService {

  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired(required = false)
  private List<RechargeServiceObserver> rechargeServiceObserverList;
  @Autowired(required = false)
  private CapitalRechargeProperties capitalRechargeProperties;

  @Override
  public RechargeProcessVo findProcessByCurrentUser() {
    LoginUserDetailsForCPS userDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
    ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey(userDetails.getUsertype());
    RechargeConditionDto conditionDto = new RechargeConditionDto();
    conditionDto.setParticipatorFlag(participatorTypeEnum.getDictCode());
    conditionDto.setMerchantUserAccount(userDetails.getAccount());
    if (CollectionUtils.isEmpty(this.rechargeServiceObserverList)) {
      return null;
    }
    RechargeProcessVo cashProcessVo = null;
    for (RechargeServiceObserver rechargeServiceObserver : rechargeServiceObserverList) {
      List<RechargeProperties> rechargeProperties = this.capitalRechargeProperties.getRecharges();
      Validate.notEmpty(rechargeProperties, "系统缺少充值配置");
      RechargeProperties rechargeProp = rechargeProperties.stream().filter(item -> Objects.equals(conditionDto.getParticipatorFlag(), item.getParticipatorType())).findAny().orElse(null);
      Validate.notNull(rechargeProp, "系统缺少【%s】类型的充值配置", conditionDto.getParticipatorFlag());
      conditionDto.setRechargeKey(rechargeProp.getRechargeKey());
      cashProcessVo = rechargeServiceObserver.onRequestRechargeProcess(conditionDto);
    }
    return cashProcessVo;
  }


}
