/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.capital.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.capital.local.entity.CapitalRecharge;
import com.biz.crm.cps.business.capital.local.repository.CapitalRechargeRepository;
import com.biz.crm.cps.business.capital.local.service.CapitalRechargeService;
import com.biz.crm.cps.business.capital.sdk.common.enums.DataSourceEnum;
import com.biz.crm.cps.business.capital.sdk.common.enums.PushStatusEnum;
import com.biz.crm.cps.business.capital.sdk.common.enums.RechargeAuditEnum;
import com.biz.crm.cps.business.capital.sdk.common.enums.RechargeStatusEnum;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="capitalRechargeService")
public class CapitalRechargeServiceImpl
implements CapitalRechargeService {
    @Autowired
    private CapitalRechargeRepository capitalRechargeRepository;
    @Autowired
    private GenerateCodeService generateCodeService;
    @Autowired
    private LoginUserService loginUserService;

    @Override
    public Page<CapitalRecharge> findByConditions(Pageable pageable, RechargeQueryDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new RechargeQueryDto();
        }
        return this.capitalRechargeRepository.findByConditions(pageable, dto);
    }

    @Override
    public CapitalRecharge findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (CapitalRecharge)((Object)this.capitalRechargeRepository.getById((Serializable)((Object)id)));
    }

    @Override
    @Transactional
    public CapitalRecharge create(CapitalRecharge capitalRecharge) {
        Validate.notNull((Object)((Object)capitalRecharge), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.createForm(capitalRecharge);
        this.createValidate(capitalRecharge);
        this.capitalRechargeRepository.saveOrUpdate((Object)capitalRecharge);
        return capitalRecharge;
    }

    @Override
    @Transactional
    public CapitalRecharge createForm(CapitalRecharge capitalRecharge) {
        Validate.notNull((Object)((Object)capitalRecharge), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (Objects.nonNull(this.generateCodeService)) {
            String rechargeCode = (String)this.generateCodeService.generateCode(StringUtils.join((Object[])new String[]{"CZ", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd")}), 1).get(0);
            Validate.isTrue((null == this.capitalRechargeRepository.findByRechargeCodeAndTenantCode(rechargeCode, TenantUtils.getTenantCode()) ? 1 : 0) != 0, (String)"\u65b0\u589e\u5145\u503c\u4fe1\u606f\u65f6,\u5145\u503c\u4fe1\u606f\u7f16\u53f7\u91cd\u590d", (Object[])new Object[0]);
            capitalRecharge.setRechargeCode(rechargeCode);
        }
        capitalRecharge.setTenantCode(TenantUtils.getTenantCode());
        Date date = new Date();
        String loginAccountName = this.loginUserService.getLoginAccountName();
        capitalRecharge.setCreateTime(date);
        capitalRecharge.setCreateAccount(loginAccountName);
        capitalRecharge.setModifyTime(date);
        capitalRecharge.setModifyAccount(loginAccountName);
        capitalRecharge.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        capitalRecharge.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        capitalRecharge.setRechargeStatus(RechargeStatusEnum.WAIT.getDictCode());
        capitalRecharge.setAuditStatus(RechargeAuditEnum.WAIT.getDictCode());
        capitalRecharge.setPushStatus(PushStatusEnum.PUSH_WAIT.getDictCode());
        if (null == capitalRecharge.getDataSource()) {
            capitalRecharge.setDataSource(DataSourceEnum.CPS_ADD.getDictCode());
        }
        return capitalRecharge;
    }

    @Override
    @Transactional
    public CapitalRecharge update(CapitalRecharge capitalRecharge) {
        this.updateValidate(capitalRecharge);
        this.capitalRechargeRepository.saveOrUpdate((Object)capitalRecharge);
        return capitalRecharge;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.capitalRechargeRepository.removeByIds(idList);
    }

    @Override
    @Transactional
    public List<CapitalRecharge> createBatch(List<CapitalRecharge> capitalRecharges) {
        Validate.notEmpty(capitalRecharges, (String)"\u6279\u91cf\u4fdd\u5b58\u6570\u636e\u65f6,\u6570\u636e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (CapitalRecharge capitalRecharge : capitalRecharges) {
            this.createForm(capitalRecharge);
            this.createValidate(capitalRecharge);
        }
        this.capitalRechargeRepository.saveBatch(capitalRecharges);
        return capitalRecharges;
    }

    @Override
    public CapitalRecharge findByRechargeCode(String rechargeCode) {
        if (StringUtils.isBlank((CharSequence)rechargeCode)) {
            return null;
        }
        return this.capitalRechargeRepository.findByRechargeCodeAndTenantCode(rechargeCode, TenantUtils.getTenantCode());
    }

    @Override
    @Transactional
    public void updatePushStatusByRechargeCodes(List<String> rechargeCodes) {
        Validate.notEmpty(rechargeCodes, (String)"\u6839\u636e\u5145\u503c\u7f16\u7801\u66f4\u6539\u63a8\u9001\u72b6\u6001\u65f6\uff0c\u5145\u503c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<CapitalRecharge> capitalRecharges = this.capitalRechargeRepository.findByRechargeCodesAndTenantCode(rechargeCodes, TenantUtils.getTenantCode());
        Validate.notEmpty(capitalRecharges, (String)"\u6839\u636e\u5145\u503c\u7f16\u7801\u66f4\u6539\u63a8\u9001\u72b6\u6001\u65f6\uff0c\u672a\u67e5\u8be2\u5230\u5145\u503c\u4fe1\u606f", (Object[])new Object[0]);
        for (CapitalRecharge capitalRecharge : capitalRecharges) {
            capitalRecharge.setPushStatus(PushStatusEnum.PUSH_SUCCESS.getDictCode());
            capitalRecharge.setPushTime(new Date());
        }
        this.capitalRechargeRepository.saveOrUpdateBatch(capitalRecharges);
    }

    private void createValidate(CapitalRecharge capitalRecharge) {
        capitalRecharge.setId(null);
        Validate.notBlank((CharSequence)capitalRecharge.getCreateAccount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u521b\u5efa\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)capitalRecharge.getCreateTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getModifyAccount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)capitalRecharge.getRechargeAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((capitalRecharge.getRechargeAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u91d1\u989d \u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeSource(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u6765\u6e90 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u72b6\u6001 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeTipCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u63d0\u793a\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getAccountCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u8d26\u53f7\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getAccountName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u8d26\u53f7\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(CapitalRecharge capitalRecharge) {
        Validate.notNull((Object)((Object)capitalRecharge), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getCreateAccount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u521b\u5efa\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)capitalRecharge.getCreateTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u521b\u5efa\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getModifyAccount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u66f4\u65b0\u4eba\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)capitalRecharge.getRechargeAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((capitalRecharge.getRechargeAmount().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u91d1\u989d \u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeSource(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u6765\u6e90 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeStatus(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u72b6\u6001 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getRechargeTipCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u63d0\u793a\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getAccountCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u8d26\u53f7\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)capitalRecharge.getAccountName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u8d26\u53f7\u540d\u79f0 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

