/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.capital.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.capital.local.entity.CapitalRecharge;
import com.biz.crm.cps.business.capital.local.repository.CapitalRechargeVoRepository;
import com.biz.crm.cps.business.capital.local.service.CapitalRechargeService;
import com.biz.crm.cps.business.capital.sdk.dto.CapitalRechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.CapitalRechargeInfoDto;
import com.biz.crm.cps.business.capital.sdk.dto.CpsRaiseRechargeAuditDto;
import com.biz.crm.cps.business.capital.sdk.dto.CpsRaiseRechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeAccountDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeDto;
import com.biz.crm.cps.business.capital.sdk.dto.RechargeQueryDto;
import com.biz.crm.cps.business.capital.sdk.dto.UserAccountRechargeDto;
import com.biz.crm.cps.business.capital.sdk.service.CapitalRechargeVoService;
import com.biz.crm.cps.business.capital.sdk.service.observer.RechargeServiceObserver;
import com.biz.crm.cps.business.capital.sdk.vo.CapitalRechargeVo;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountBatchDto;
import com.biz.crm.cps.external.tax.raise.sdk.dto.base.MerchantAccountDto;
import com.biz.crm.cps.external.tax.raise.sdk.service.recharge.TaxRaiseRechargeAccountVoService;
import com.biz.crm.cps.external.tax.raise.sdk.vo.recharge.TaxRaiseRechargeAccountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="capitalRechargeVoService")
public class CapitalRechargeVoServiceImpl
implements CapitalRechargeVoService {
    @Autowired
    private CapitalRechargeService capitalRechargeService;
    @Autowired
    private CapitalRechargeVoRepository capitalRechargeVoRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private List<RechargeServiceObserver> rechargeServiceObserverList;
    @Autowired
    private TaxRaiseRechargeAccountVoService taxRaiseRechargeAccountVoService;

    public Page<CapitalRechargeVo> findByConditions(Pageable pageable, RechargeQueryDto dto) {
        Page<CapitalRechargeVo> page;
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new RechargeQueryDto();
        }
        if (!CollectionUtils.isEmpty((Collection)(page = this.capitalRechargeVoRepository.findByConditions(pageable, dto)).getRecords())) {
            List capitalRechargeVos = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)page.getRecords(), CapitalRechargeVo.class, CapitalRechargeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            List<String> merchantUserAccounts = capitalRechargeVos.stream().map(CapitalRechargeVo::getMerchantUserAccount).distinct().collect(Collectors.toList());
            List<TaxRaiseRechargeAccountVo> accountVos = this.findAccountByAccountCodes(merchantUserAccounts);
            if (!CollectionUtils.isEmpty(accountVos)) {
                Map map = accountVos.stream().collect(Collectors.toMap(TaxRaiseRechargeAccountVo::getMerchantUserAccount, Function.identity()));
                for (CapitalRechargeVo capitalRechargeVo : capitalRechargeVos) {
                    if (!map.containsKey(capitalRechargeVo.getMerchantUserAccount())) continue;
                    TaxRaiseRechargeAccountVo accountVo = (TaxRaiseRechargeAccountVo)map.get(capitalRechargeVo.getMerchantUserAccount());
                    this.handleCapitalRechargeVo(capitalRechargeVo, accountVo);
                }
            }
            page.setRecords(capitalRechargeVos);
        }
        return page;
    }

    public Page<CapitalRechargeVo> findCurrentUserByConditions(Pageable pageable, RechargeQueryDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new RechargeQueryDto();
        }
        LoginUserDetailsForCPS loginUserDetailsForCPS = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUserDetailsForCPS, (String)"\u672a\u83b7\u53d6\u5230\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        dto.setAccountCode(loginUserDetailsForCPS.getAccount());
        Page<CapitalRechargeVo> page = this.capitalRechargeVoRepository.findByConditions(pageable, dto);
        return page;
    }

    public CapitalRechargeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        CapitalRechargeVo capitalRechargeVo = new CapitalRechargeVo();
        CapitalRecharge capitalRecharge = this.capitalRechargeService.findById(id);
        if (null == capitalRecharge) {
            return capitalRechargeVo;
        }
        capitalRechargeVo = (CapitalRechargeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)capitalRecharge, CapitalRechargeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        MerchantAccountDto accountDto = new MerchantAccountDto();
        accountDto.setMerchantUserAccount(capitalRecharge.getMerchantUserAccount());
        TaxRaiseRechargeAccountVo accountVo = this.taxRaiseRechargeAccountVoService.findByMerchantAccountDto(accountDto);
        if (null != accountVo) {
            this.handleCapitalRechargeVo(capitalRechargeVo, accountVo);
        }
        return capitalRechargeVo;
    }

    public void create(RechargeDto rechargeDto) {
        this.createValidateDto(rechargeDto);
        ArrayList capitalRecharges = Lists.newArrayList();
        List<String> merchantUserAccounts = rechargeDto.getRechargeAccounts().stream().map(RechargeAccountDto::getMerchantUserAccount).collect(Collectors.toList());
        List<TaxRaiseRechargeAccountVo> accountVos = this.findAccountByAccountCodes(merchantUserAccounts);
        Validate.notEmpty(accountVos, (String)"\u6839\u636e\u7528\u6237\u8d26\u6237\u96c6\u5408\u672a\u67e5\u8be2\u5230\u7528\u6237\u8d26\u6237", (Object[])new Object[0]);
        Map<String, String> accountNameMap = accountVos.stream().collect(Collectors.toMap(TaxRaiseRechargeAccountVo::getMerchantUserAccount, TaxRaiseRechargeAccountVo::getCompanyName));
        for (RechargeAccountDto rechargeAccount : rechargeDto.getRechargeAccounts()) {
            CapitalRecharge capitalRecharge = (CapitalRecharge)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)rechargeDto, CapitalRecharge.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            capitalRecharge.setMerchantUserAccount(rechargeAccount.getMerchantUserAccount());
            capitalRecharge.setAccountCode(rechargeAccount.getMerchantUserAccount());
            capitalRecharge.setRechargeAmount(rechargeAccount.getRechargeAmount());
            capitalRecharge.setAccountName(accountNameMap.get(rechargeAccount.getMerchantUserAccount()));
            capitalRecharges.add(capitalRecharge);
        }
        List<CapitalRecharge> saveCapitalRecharges = this.capitalRechargeService.createBatch(capitalRecharges);
        List capitalRechargeDtos = (List)this.nebulaToolkitService.copyCollectionByBlankList(saveCapitalRecharges, CapitalRecharge.class, CapitalRechargeDto.class, HashSet.class, LinkedList.class, new String[0]);
        CapitalRechargeInfoDto capitalRechargeInfoDto = new CapitalRechargeInfoDto();
        capitalRechargeInfoDto.setRechargeKey(rechargeDto.getRechargeKey());
        capitalRechargeInfoDto.setCapitalRechargeDtos(capitalRechargeDtos);
        for (RechargeServiceObserver rechargeServiceObserver : this.rechargeServiceObserverList) {
            rechargeServiceObserver.onRecharge(capitalRechargeInfoDto);
        }
    }

    public CapitalRechargeVo findByRechargeCode(String rechargeCode) {
        if (StringUtils.isBlank((CharSequence)rechargeCode)) {
            return null;
        }
        CapitalRecharge capitalRecharge = this.capitalRechargeService.findByRechargeCode(rechargeCode);
        return (CapitalRechargeVo)this.nebulaToolkitService.copyObjectByBlankList((Object)capitalRecharge, CapitalRechargeVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void updatePushStatusByRechargeCodes(List<String> rechargeCodes) {
        Validate.notEmpty(rechargeCodes, (String)"\u6839\u636e\u5145\u503c\u7f16\u7801\u66f4\u6539\u63a8\u9001\u72b6\u6001\u65f6\uff0c\u5145\u503c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.capitalRechargeService.updatePushStatusByRechargeCodes(rechargeCodes);
    }

    @Transactional
    public void createByCurrentUser(UserAccountRechargeDto dto) {
        this.createValidateUserAccountRechargeDto(dto);
        RechargeDto rechargeDto = (RechargeDto)this.nebulaToolkitService.copyObjectByBlankList((Object)dto, RechargeDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        ArrayList rechargeAccounts = Lists.newArrayList();
        LoginUserDetailsForCPS loginUserDetailsForCPS = (LoginUserDetailsForCPS)this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
        Validate.notNull((Object)loginUserDetailsForCPS, (String)"\u672a\u83b7\u53d6\u5230\u767b\u5f55\u4fe1\u606f", (Object[])new Object[0]);
        RechargeAccountDto rechargeAccountDto = new RechargeAccountDto();
        rechargeAccountDto.setAccountCode(loginUserDetailsForCPS.getAccount());
        rechargeAccountDto.setMerchantUserAccount(loginUserDetailsForCPS.getAccount());
        rechargeAccountDto.setRechargeAmount(dto.getRechargeAmount());
        rechargeAccounts.add(rechargeAccountDto);
        rechargeDto.setRechargeAccounts((List)rechargeAccounts);
        this.create(rechargeDto);
    }

    @Transactional
    public void updateAuditStatusByAuditDto(CpsRaiseRechargeAuditDto dto) {
        Validate.notNull((Object)dto, (String)"\u7a0e\u7b79\u5e73\u53f0\u5145\u503c\u5ba1\u6838\u72b6\u6001\u540c\u6b65\u65f6,\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((StringUtils.isNotBlank((CharSequence)dto.getRechargeCode()) || StringUtils.isNotBlank((CharSequence)dto.getPushCode()) ? 1 : 0) != 0, (String)"\u7a0e\u7b79\u5e73\u53f0\u5145\u503c\u5ba1\u6838\u72b6\u6001\u540c\u6b65\u65f6,\u5145\u503c\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getAuditStatus(), (String)"\u7a0e\u7b79\u5e73\u53f0\u5145\u503c\u5ba1\u6838\u72b6\u6001\u540c\u6b65\u65f6,\u5ba1\u6838\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRechargeStatus(), (String)"\u7a0e\u7b79\u5e73\u53f0\u5145\u503c\u5ba1\u6838\u72b6\u6001\u540c\u6b65\u65f6,\u5145\u503c\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getPushCode())) {
            this.capitalRechargeVoRepository.updateStatusByPushCode(dto.getPushCode(), dto.getAuditStatus(), dto.getRechargeStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRechargeCode())) {
            this.capitalRechargeVoRepository.updateStatusByRechargeCode(dto.getRechargeCode(), dto.getAuditStatus(), dto.getRechargeStatus());
        }
    }

    @Transactional
    public void createBatch(CpsRaiseRechargeDto dto) {
        Validate.notEmpty((Collection)dto.getRechargeDtos(), (String)"\u6279\u91cf\u65b0\u589e\u5145\u503c\u4fe1\u606f\u65f6,\u5145\u503c\u4fe1\u606f\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List capitalRecharges = (List)this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getRechargeDtos(), CapitalRechargeDto.class, CapitalRecharge.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List<String> merchantUserAccounts = capitalRecharges.stream().map(CapitalRecharge::getMerchantUserAccount).distinct().collect(Collectors.toList());
        List<TaxRaiseRechargeAccountVo> accountVos = this.findAccountByAccountCodes(merchantUserAccounts);
        Validate.notEmpty(accountVos, (String)"\u6839\u636e\u7528\u6237\u8d26\u6237\u96c6\u5408\u672a\u67e5\u8be2\u5230\u7528\u6237\u8d26\u6237", (Object[])new Object[0]);
        Map<String, String> accountNameMap = accountVos.stream().collect(Collectors.toMap(TaxRaiseRechargeAccountVo::getMerchantUserAccount, TaxRaiseRechargeAccountVo::getCompanyName));
        for (CapitalRecharge capitalRecharge : capitalRecharges) {
            capitalRecharge.setAccountName(accountNameMap.get(capitalRecharge.getMerchantUserAccount()));
            capitalRecharge.setPushCode(capitalRecharge.getRechargeCode());
        }
        this.capitalRechargeService.createBatch(capitalRecharges);
    }

    private void createValidateDto(RechargeDto rechargeDto) {
        Validate.notNull((Object)rechargeDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rechargeDto.getRechargeSource(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u6765\u6e90 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rechargeDto.getRechargeTipCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u63d0\u793a\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)rechargeDto.getRechargeAccounts(), (String)"\u65b0\u589e\u6570\u636e\u65f6,\u5145\u503c\u8d26\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)rechargeDto.getRechargeKey(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u7c7b\u578bkey \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (RechargeAccountDto rechargeAccountDto : rechargeDto.getRechargeAccounts()) {
            Validate.notBlank((CharSequence)rechargeAccountDto.getAccountCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u8d26\u6237\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notNull((Object)rechargeAccountDto.getRechargeAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            rechargeAccountDto.setMerchantUserAccount(rechargeAccountDto.getAccountCode());
        }
        Validate.notEmpty(this.rechargeServiceObserverList, (String)"\u5145\u503c\u6a21\u5757\u4e0d\u5b58\u5728", (Object[])new Object[0]);
    }

    private void createValidateUserAccountRechargeDto(UserAccountRechargeDto dto) {
        Validate.notNull((Object)dto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRechargeSource(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u6765\u6e90 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getRechargeTipCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u63d0\u793a\u7f16\u7801 \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRechargeAmount(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c \u5145\u503c\u91d1\u989d \u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void handleCapitalRechargeVo(CapitalRechargeVo rechargeVo, TaxRaiseRechargeAccountVo accountVo) {
        rechargeVo.setAccountName(accountVo.getCompanyName());
        rechargeVo.setCompanyName(accountVo.getCompanyName());
        rechargeVo.setSocialCreditCode(accountVo.getOrganization());
        rechargeVo.setBankCardNo(accountVo.getBankCardNo());
        rechargeVo.setRlegalPersonName(accountVo.getLegalName());
        rechargeVo.setCustomerId(accountVo.getCustomerId());
    }

    private List<TaxRaiseRechargeAccountVo> findAccountByAccountCodes(List<String> accountCodes) {
        MerchantAccountBatchDto merchantAccountBatchDto = new MerchantAccountBatchDto();
        merchantAccountBatchDto.setMerchantUserAccounts(accountCodes);
        return this.taxRaiseRechargeAccountVoService.findByMerchantAccountBatchDto(merchantAccountBatchDto);
    }
}

